import React, { Component } from 'react';
import { BarChart } from 'amos-viz/lib/echarts';
// import PropTypes from 'prop-types';

import {
  lastYearAlarmAction
} from './../api';

class AlarmBarChart extends Component {
  constructor(props) {
    super(props);
    this.state = {
      xData: [],
      yData: [],
      yData1: []
    };
  }

  componentDidMount() {
    this.onRequest();
  }

  onRequest = () => {
    lastYearAlarmAction().then(d => {
      let xData = [];
      let yData = [];
      let yData1 = [];
      if (d) {
        d.forEach(item => {
          xData.push(item.name ? item.name : '');
          yData.push(item.alarmEquipNumber ? item.alarmEquipNumber : 0);
          yData1.push(item.alarmTimes ? item.alarmTimes : 0);
        });
      }
      this.setState({ xData, yData, yData1 });
    });
  }

  getPieOption = () => {
    const { xData, yData, yData1 } = this.state;
    return {
      grid: {
        x: 50,
        y: 40,
        x2: 50,
        y2: 70,
        borderWidth: 5
      },
      tooltip: {
        trigger: 'axis'
      },
      legend: {
        data: ['告警设备', '警情数量'],
        bottom: '88%',
        textStyle: {
          color: '#fff'
        }
      },
      xAxis: {
        name: '换流站',
        type: 'category',
        data: xData,
        axisPointer: {
          type: 'shadow'
        },
        axisLabel: {
          margin: 10,
          color: '#fff',
          fontSize: 12,
          rotate: -30
        },
        axisLine: {
          lineStyle: {
            color: '#fff'
          }
        },
        axisTick: {
          alignWithLabel: true,
          color: '#fff',
          lineStyle: {
            color: '#fff'
          }
        }
      },
      yAxis: {
        name: '数目',
        type: 'value',
        axisLabel: {
          margin: 10,
          color: '#fff',
          fontSize: 16
        },
        axisLine: {
          lineStyle: {
            color: '#fff'
          }
        },
        splitLine: {
          show: true,
          lineStyle: {
            type: 'dashed'
          }
        }
      },
      series: [{
        name: '告警设备',
        data: yData,
        type: 'bar',
        label: {
          normal: {
            show: false,
            position: 'top',
            textStyle: {
              color: '#fff',
              fontSize: '10px'
            }
          }
        },
        // itemStyle: {
        //   normal: { color: '#D87A16' }
        // },
        itemStyle: {
          normal: {
            color: {
              type: 'linear',
              x: 0,
              y: 0,
              x2: 1,
              y2: 1,
              colorStops: [
                {
                  offset: 0,
                  color: '#EE6328'
                },
                {
                  offset: 1,
                  color: '#FD7D47'
                }
              ],
              global: false
            }
          }
        },
        barWidth: 15,
        showBackground: true,
        legendHoverLink: true,
        stack: 'x'
      },
      {
        name: '警情数量',
        data: yData1,
        type: 'bar',
        label: {
          normal: {
            show: false,
            position: 'top',
            textStyle: {
              color: '#fff',
              fontSize: '10px'
            }
          }
        },
        itemStyle: {
          normal: {
            color: {
              type: 'linear',
              x: 0,
              y: 0,
              x2: 1,
              y2: 1,
              colorStops: [
                {
                  offset: 0,
                  color: '#1E9957'
                },
                {
                  offset: 1,
                  color: '#4AEFA0'
                }
              ],
              global: false
            }
          }
        },
        barWidth: 15,
        showBackground: true,
        legendHoverLink: true,
        stack: 'x'
      }
      ]
      // ,
      // dataZoom: [{
      //   type: 'slider',
      //   show: true,
      //   start: 0,
      //   end: 45,
      //   handleSize: 8,
      //   dataBackground: {
      //     lineStyle: {
      //       color: 'rgba(225, 87, 19, 1)',
      //       shadowBlur: 1
      //     }
      //   },
      //   textStyle: {
      //     color: '#fff'
      //   }
      // }
      // ]
    };
  }

  render() {
    return (
      <div className="ccs-on-iot-monitoring-statistics" style={{ height: '100%' }} >
        <div className="ccs-on-iot-monitoring-statistics-head"> <span>近1年警情统计</span></div>
        {
          // <div className="ccs-com-screencard-header">
          //   <span>换流站现有隐患</span>
          // </div>
        }
        <div className="ccs-on-iot-monitoring-statistics-chart">
          <BarChart
            option={this.getPieOption()}
          />
        </div>
      </div>
    );
  }
}

export default AlarmBarChart;
