import React, { Component } from 'react';
import { LineChart } from 'amos-viz/lib/echarts';
import momentDateUtil from '../../common/utils/momentDateUtil';
// import PropTypes from 'prop-types';
import {
  alarmTrendAction
} from './../api';

class AlarmLineChart extends Component {
  constructor(props) {
    super(props);
    this.state = {
      dayList: [], // 前端生成最近一个月日期 x轴
      yData: []
    };
  }

  componentDidMount() {
    this.onRequest();
  }

  onRequest = () => {
    // 获取最近一月的开始时间结束时间
    const { beginDate, endDate } = momentDateUtil.getLast30Days();
    const dayList = momentDateUtil.enumerateDaysBetweenDates(beginDate, endDate);
    let yData = [];
    alarmTrendAction(beginDate, endDate).then(d => {
      if (d) {
        yData = [
          {
            name: '故障报警',
            data: d.faultAlarm ? d.faultAlarm : [],
            type: 'line',
            smooth: true
          },
          {
            name: '火灾报警',
            data: d.fireAlarm ? d.fireAlarm : [],
            type: 'line',
            smooth: true
          },
          {
            name: '屏蔽报警',
            data: d.shieldAlarm ? d.shieldAlarm : [],
            type: 'line',
            smooth: true
          },
          {
            name: '漏油',
            data: d.oilLeakAlarm ? d.oilLeakAlarm : [],
            type: 'line',
            smooth: true
          },
          {
            name: '告警',
            data: d.alarm ? d.alarm : [],
            type: 'line',
            smooth: true
          }
        ];
        this.setState({ yData });
      }
    });
    this.setState({
      dayList
    });
  }

  getPieOption = () => {
    const { dayList, yData } = this.state;
    return {
      color: ['#DBC521', '#EE6328', '#54DBFF', '#3B9DFF', '#C155E6'],
      grid: {
        x: 50,
        y: 40,
        x2: 50,
        y2: 40,
        borderWidth: 5
      },
      tooltip: {
        trigger: 'axis'
      },
      legend: {
        data: ['故障报警', '火灾报警', '屏蔽报警', '漏油', '告警'],
        bottom: '88%',
        textStyle: {
          color: '#fff'
        }
      },
      xAxis: {
        name: '日期',
        type: 'category',
        boundaryGap: false,
        data: dayList,
        axisPointer: {
          type: 'line'
        },
        axisLabel: {
          margin: 10,
          color: '#fff',
          fontSize: 12,
          rotate: -30
        },
        axisLine: {
          lineStyle: {
            color: '#fff'
          }
        },
        axisTick: {
          alignWithLabel: true,
          color: '#fff',
          lineStyle: {
            color: '#fff'
          }
        }
      },
      yAxis: {
        name: '数目',
        type: 'value',
        axisLabel: {
          margin: 10,
          color: '#fff',
          fontSize: 16
        },
        axisLine: {
          lineStyle: {
            color: '#fff'
          }
        },
        splitLine: {
          show: true,
          lineStyle: {
            type: 'dashed'
          }
        }
      },
      series: yData
    };
  }


  render() {
    return (
      <div className="ccs-on-iot-monitoring-statistics" style={{ height: '94%' }} >
        <div className="ccs-on-iot-monitoring-statistics-head"> <span>近30日警情变化趋势</span></div>
        {
          // <div className="ccs-com-screencard-header">
          // <span>近一月告警隐患趋势</span>
          // </div>
        }
        <div className="ccs-on-iot-monitoring-statistics-chart">
          <LineChart
            option={this.getPieOption()}
          />
        </div>
      </div>
    );
  }
}

export default AlarmLineChart;
