import React, { Component } from 'react';
import { ScreenCard, withSubscribeMQTT } from './../../common';
import {
  iotAccessSummaryAction
} from './../api';

/**
 * 接入汇总
 * @class AccessSummary
 * @extends {Component}
 */
@withSubscribeMQTT({ topic: 'alertNotice' })
class AccessSummary extends Component {
  static propTypes = {

  }

  constructor(props) {
    super(props);
    this.state = {
      accessSummaryData: {}
    };
  }

  componentDidMount() {
    this.onRequest();
  }

  onRequest = () => {
    iotAccessSummaryAction().then(d => {
      this.setState({ accessSummaryData: d || {} });
    });
  }

  render() {
    const { accessSummaryData } = this.state;
    return (
      <ScreenCard title="物联接入汇总">
        <div className="ccs-disaster-access-summary-content">
          <div className="ccs-disaster-access-summary-item">
            <div className="ccs-disaster-access-summary-item-name">
              <img src="upload/sfcc/common/image/接入设备2x.png" alt="" />
            </div>
            <div className="ccs-disaster-access-summary-item-value">
              <div className="ccs-disaster-access-summary-item-value-right">
                <p className="ccs-disaster-access-summary-item-value-right-p1">{accessSummaryData.totalIotEquipment || 0}</p>
                <p className="ccs-disaster-access-summary-item-value-right-p2">台</p>
              </div>
              <p className="ccs-disaster-access-summary-item-value-right-p3">总接入设备</p>
            </div>
          </div>
        </div>
        <div className="ccs-disaster-access-summary-content">
          <div className="ccs-disaster-access-summary-item">
            <div className="ccs-disaster-access-summary-item-name">
              <img src="upload/sfcc/common/image/告警设备2x.png" alt="" />
            </div>
            <div className="ccs-disaster-access-summary-item-value">
              <div className="ccs-disaster-access-summary-item-value-right">
                <p className="ccs-disaster-access-summary-item-value-right-p1">{accessSummaryData.todayAlarmEquipment || 0}</p>
                <p className="ccs-disaster-access-summary-item-value-right-p2">台</p>
              </div>
              <p className="ccs-disaster-access-summary-item-value-right-p3">今日告警设备</p>
            </div>
          </div>
        </div>
      </ScreenCard>
    );
  }
}

export default AccessSummary;
