import React from 'react';
import PropTypes from 'prop-types';
import { commond } from '@gm/graphmod-mapsdk';
import { UUID } from 'amos-tool';
import VideoModal from './VideoModal';
import mapConfig from './../config';
import { message, eventConsts } from './../../eventConsts';
import { MenuEnum } from './../../config';
import View3d from './View3d';
import './index.scss';


const { EventConsts }  = commond;

class OperEvent extends commond.BasicCustom {
  constructor(props) {
    super(props);
    this.isToHlz = false;
  }

  /**
   * 值格式化展示
   * @returns
   */
  valueFormat = {

  }
  /**
   *  切换到全国地图
   */
  customMapBack = () => {
    if (!this.isToHlz) {
      this.mapEvent.setMapLevels([5, 5]);
      this.mapEvent.clearMap();
      this.mapEvent.mapBack();
      return;
    }
    this.getConfig().mapPointConfig['实时告警'].common =
      { ...this.getConfig().mapPointConfig['实时告警'].common, relationLayer: '换流站', master: true, relationId: 'stationCode' };
    this.getConfig().mapPointConfig['换流站'].common =
      { ...this.getConfig().mapPointConfig['换流站'].common, relationLayer: '实时告警', master: false, relationId: 'stationCode' };
    this.updateConfig(this.getConfig());
    this.mapEvent.setMapLevels([5, 5]);
    this.mapEvent.clearMap();
    this.onChangeGlobalData('stationCode', undefined);
    this.onChangeGlobalData('alert', undefined);
    this.onChangeGlobalData('resourceKeys', []);
    this.mapEvent.mapBack();
    const data = {
      message: MenuEnum.ALL.value,
      uuid: UUID.uuid('16')
    };
    message.storageTrigger(eventConsts.SWITCH_WHOLE_COUNTRY_STATION,data);
    message.storageTrigger(eventConsts.STATION_CODE,undefined);
    this.isToHlz = false;
  }
  /**
   * 单击告警
   * @param {*} data
   */
  alartClick = (data) => {
    // const lastIsToHlz = this.isToHlz;
    // this.switchToHlz(data);
    // const alarmData = {
    //   ...data,
    //   lng: data.sourceLng,
    //   lat: data.sourceLat
    // };
    // if (!lastIsToHlz) {
    //   setTimeout(() => {
    //     this.mapEvent.locationToPoint(alarmData, { id: '实时告警' });
    //   }, 1000);
    // }
  }

  /**
   * 单击隐患
   * @param {*} data
   */
  hiddenDangerClick = (data) => {
    // this.switchToHlz(data);
  }

  /**
   * 警情列表双击、地图告警点双击
   * @param {*} data
   */
  handleAlartDoubleClick = (data)=>{
    if (data.signalType === 'fireAlarm'){
      // 准备副屏及应急指挥数据
      this.intoStationModal(data);
      message.storageTrigger(eventConsts.EMERGENCY_MODEL, UUID.uuid('16'));
    } else {
      // 有3维场景
      if (data.view3dUrl){
        // 准备副屏及应急指挥数据
        this.intoStationModal(data);
        const { token } = this.props.appConfig;
        this.onOpen(<View3d onClose={this.closeView3d} url={`${data.view3dUrl}?token=${token}`}/>,EventConsts.AREA_MODAL);
      } else {
        // 无3维场景
        const lastIsToHlz = this.isToHlz;
        // 换流站模式下双击场景，返回的经纬度字段为警情的
        this.switchToHlz(data);
        const alarmData = {
          ...data,
          lng: data.sourceLng,
          lat: data.sourceLat
        };
        // 全国模式下双击场景
        // 进入换流站地图时，定位到警情，需要额外处理的原因时，全国时，返回的经纬度字段为换流站的，所以需要再定位到警情
        if (!lastIsToHlz) {
          setTimeout(() => {
            this.mapEvent.locationToPoint(alarmData, { id: '实时告警' });
          }, 500);
        }
      }
    }
  }

  /**
   * 进入到换流站模式，准备数据
   */
  intoStationModal = (data)=>{
    // 先发送火警信息，用于页面数据初始化
    const countryStationFlag = {
      message: MenuEnum.STATION.value,
      uuid: UUID.uuid('16')
    };
    const alarmData = {
      ...data,
      message: data.stationCode,
      uuid: UUID.uuid('16'),
      lng: data.sourceLng,
      lat: data.sourceLat
    };
    // 物联监控逻辑判断当前处于换流站模式，还是全国模式
    message.storageTrigger(eventConsts.SWITCH_WHOLE_COUNTRY_STATION,countryStationFlag);
    // 选择的换流站信息（告警自带的数据）：安全态势及逻辑副屏使用
    message.storageTrigger(eventConsts.STATION_CODE,alarmData);
    // 缓存选中的告警数据，应急指挥逻辑
    message.storageTrigger(eventConsts.ALARM_INFO, alarmData);
  }

  /**
   * 推出3维模式
   */
  closeView3d = ()=>{
    // 1.3d页面关闭
    this.onClose(EventConsts.AREA_MODAL);
    // 2.设置标识进入到全国模式，用于副屏菜单筛选切换
    const data = {
      message: MenuEnum.ALL.value,
      uuid: UUID.uuid('16')
    };
    message.storageTrigger(eventConsts.SWITCH_WHOLE_COUNTRY_STATION,data);
    message.storageTrigger(eventConsts.STATION_CODE,undefined);
  }

  /**
   * 切换到换流站地图
   */
  switchToHlz = ({ stationCode, lng, lat, ...other }) => {
    // 1.进入换流站模式，发送消息
    const data = {
      message: MenuEnum.STATION.value,
      uuid: UUID.uuid('16')
    };
    const stationCodeData = {
      message: stationCode,
      stationCode,
      uuid: UUID.uuid('16'),
      lng,
      lat,
      ...other
    };
    // 物联监控逻辑，用于副屏菜单筛选切换
    message.storageTrigger(eventConsts.SWITCH_WHOLE_COUNTRY_STATION,data);
    // 选择的换流站信息（告警自带的数据）：安全态势及逻辑副屏使用
    message.storageTrigger(eventConsts.STATION_CODE,stationCodeData);
    // 缓存选中的告警数据，应急指挥逻辑
    message.storageTrigger(eventConsts.ALARM_INFO, stationCodeData);
    // 已经进入到换流站模式，不再进行重复的操作数据
    if (this.isToHlz) {
      return;
    }
    // 2.首次进入到换流站模式，定位到换流站点，而非一个具体的警情,处理节点关系，否则地图主子关系的点显示不全
    this.getConfig().mapPointConfig['实时告警'].common =
      { ...this.getConfig().mapPointConfig['实时告警'].common, relationLayer: undefined, master: undefined, relationId: undefined };
    this.getConfig().mapPointConfig['换流站'].common =
      { ...this.getConfig().mapPointConfig['换流站'].common, relationLayer: undefined, master: undefined, relationId: undefined };
    this.updateConfig(this.getConfig());
    this.onChangeGlobalData('stationCode', stationCode);
    this.onChangeGlobalData('resourceKeys', mapConfig({}).resourceConfig.map(e => e.key));
    this.mapEvent.setMapLevels([17, 19]);
    this.isToHlz = true;
  }

  alertDefaultChoose=(data)=>{
    const { alert }  = this.getGlobalData();
    if (data && data.length > 0 && !alert){
      // 默认选中第一条或者告警信息
      const fireAlarmFirstData = data.find(d=>d.signalType === 'fireAlarm');
      message.storageTrigger(eventConsts.ALARM_INFO,fireAlarmFirstData);
    }
  }


  /**
   * 点击地图上的标记点
   * @param {MapPoint} data 地图点数据
  */
  onPointClick(data) {
    // 点击地图
    if (data.classify === '摄像头') {
      this.onOpen(<VideoModal data={data.data} visible />, EventConsts.AREA_MODAL);
    }
  }
  /**
   * 双击地图上的标记点
   * @param {MapPoint} data 地图点数据
  */
  onPointDoubleClick(data) {
    // 点击地图上的换流站
    if (data.classify === '换流站') {
      this.switchToHlz({ ...data.data, stationCode: (data.data || {}).code });
      this.mapEvent.locationToPoint(data.data, { id: '换流站' });
    }
    if (data.classify === '最新隐患') {
      this.switchToHlz(data.data);
      this.mapEvent.locationToPoint(data.data, { id: '最新隐患' });
    }
    if (data.classify === '实时告警') {
      this.handleAlartDoubleClick(data.data);
    }
  }
}

OperEvent.propTypes = {
  onOpen: PropTypes.func,
  onClose: PropTypes.func
};

export default OperEvent;
