import React, { Component } from 'react';
import Picture from './../components/Picture';
import { LabelValueFrame } from './../../common';
import { keysPartsDetailsAction }  from './../../api';
import PartsTree from './PartsTree';
/**
 * 重点部位 - 单位
 *
 * @class PartsKey
 * @extends {Component}
 */
class PartsKey extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: {}
    };
  }

  handleSelect = (key) => {
    keysPartsDetailsAction(key).then(d => this.setState({ data: d || {} }));
  }

  renderBasic = () => {
    return [
      { label: '重点部位名称', value: 'name', labelWidth: '11em', width: '100%' },
      { label: '所属部门', value: 'belongName', labelWidth: '11em', width: '100%' },
      { label: '所在建筑', value: 'buildingName', labelWidth: '11em', width: '100%' },
      { label: '位置描述', value: 'addressDesc', labelWidth: '11em', width: '100%' },
      { label: '建筑面积', value: '{buildingArea}㎡', defaultValue: '0', labelWidth: '11em', width: '100%' },
      { label: '耐火等级', value: 'fireEnduranceRateName', labelWidth: '11em', width: '100%' },
      { label: '使用性质', value: 'useNatureName', labelWidth: '11em', width: '100%' },
      { label: '责任人', value: 'chargePerson', labelWidth: '11em', width: '100%' },
      { label: '确定重点防火部位原因', value: 'keyPreventionReason', labelWidth: '11em', width: '100%' },
      { label: '消防设施情况', value: 'fireFacilitiesInfo', labelWidth: '11em', width: '100%' },
      { label: '防火标志设立情况', value: (data) => data.firePreventionFlag ? '已设立' : '未设立', labelWidth: '11em', width: '100%' },
      { label: '危险源', value: 'hazard', labelWidth: '11em', width: '100%' },
      { label: '消防安全管理措施', value: 'safetyManagementMeasures', labelWidth: '11em', width: '100%' },
      { label: '防范手段和措施', value: 'preventiveMeasures', labelWidth: '11em', width: '100%' }
    ];
  }

  render() {
    const { data } = this.state;
    return (
      <div className="ccs-box">
        <div className="ccs-left-box ccs-keyparts">
          <PartsTree onSelect={this.handleSelect} {...this.props} />
          <div className="ccs-keyparts-details ccs-scrollbar"><LabelValueFrame columns={this.renderBasic()} data={data} /></div>
        </div>
        <div className="ccs-right-box">
          <Picture imgArr={data.attachmentsList || []} length={(data.attachmentsList || []).length || 0}/>
        </div>
      </div>
    );
  }
}

export default PartsKey;
