import React, { Component } from 'react';
import { Tabs } from 'amos-framework';
import Picture from './../components/Picture';
import { message, eventConsts } from './../../eventConsts';
import { aircraftAction }  from './../../api';
import { IconTitle, LabelValueFrame } from './../../common';

const { TabList, Tab, TabPanel } = Tabs;

/**
 * 救援对象 - 航空器
 *
 * @class Aircraft
 * @extends {Component}
 */
class Aircraft extends Component {
  constructor(props) {
    super(props);
    this.state = {
      alarm: message.getStorageData(eventConsts.FIRE_ACTIVE_CAHNGE) || { sequenceNbr: '1414823784643649537' },
      // alarm: { sequenceNbr: '1420561249661337602' },
      data: {}
    };
  }

  componentDidMount() {
    this.onRequest();
    message.on(eventConsts.FIRE_ACTIVE_CAHNGE, (data) => {
      this.setState({ alarm: data || {} }, this.onRequest);
    }, true, true);
  }

  onRequest = () => {
    const { alarm = {} } = this.state;
    aircraftAction(alarm.sequenceNbr).then(d => this.setState({ data: d || {} }));
  }

  renderBasic = () => {
    return [
      { label: '飞机型号', value: 'aircraftModel', labelWidth: '10em', width: '50%' },
      { label: '中文全称', value: 'fullName', labelWidth: '10em', width: '50%' },
      { label: '飞机长度(m)', value: '{aircraftLength}m', defaultValue: 0, labelWidth: '10em', width: '50%' },
      { label: '机舱长度(m)', value: '{cabinLength}m', defaultValue: 0, labelWidth: '10em', width: '50%' },
      { label: '尾翼高度(m)', value: 'tailHeight', labelWidth: '10em', width: '50%' },
      { label: '翼展(m)', value: '{wingspan}m', defaultValue: 0, labelWidth: '10em', width: '50%' },
      { label: '机身直径(m)', value: `{fuselageDiameter}m`, defaultValue: 0, labelWidth: '10em', width: '50%' },
      { label: '翼展面积(m²)', value: '{wingspanArea}㎡', defaultValue: 0, labelWidth: '10em', width: '50%' },
      { label: '发动机类型', value: 'engineType', labelWidth: '10em', width: '50%' },
      { label: '发动机数量(台)', value: '{enginesmNum}台', defaultValue: 0, labelWidth: '10em', width: '50%' },
      { label: '发动机型号', value: 'engineModel', labelWidth: '10em', width: '50%' },
      { label: '燃油类型', value: 'fuelType', labelWidth: '10em', width: '50%' },
      { label: '最大载油量(L)', value: '{oilLoadMax}L', defaultValue: 0, labelWidth: '10em', width: '50%' },
      { label: '标准燃油(KG)', value: '{standardFuel}KG', defaultValue: 0, labelWidth: '10em', width: '50%' },
      { label: '空重(KG)', value: '{emptyWeight}KG', defaultValue: 0, labelWidth: '10em', width: '50%' },
      { label: '飞机主要构造材料', value: 'structuralMaterial', labelWidth: '10em', width: '50%' },
      { label: '氧气瓶数量(组)', value: '{oxygenCylinderNum}组', defaultValue: 0, labelWidth: '10em', width: '50%' },
      { label: '氧气瓶位置描述', value: 'oxygenCylinderLocation', labelWidth: '10em', width: '50%' }
    ];
  }

  renderRun = () => {
    return [
      { label: '标准坐席数', value: '{seatNum}人', defaultValue: 0, labelWidth: '10em', width: '50%' },
      { label: '商载', value: '{commercialLoad}T', defaultValue: 0, labelWidth: '10em', width: '50%' },
      { label: '货仓容积', value: '{warehouseVolume}m³', defaultValue: 0, labelWidth: '10em', width: '50%' },
      { label: '最大起飞总重', value: '{takeoffWeightNum}T', defaultValue: 0, labelWidth: '10em', width: '50%' },
      { label: '最大巡航速度', value: '{cruiseSpeedNum}马赫', defaultValue: 0, labelWidth: '10em', width: '50%' },
      { label: '航程', value: '{voyage}公里', labelWidth: '10em', width: '50%' }
    ];
  }

  renderDescr = () => {
    return [
      { label: '主要设施', value: 'facilitie', labelWidth: '10em', width: '100%' },
      { label: '主要燃烧物质', value: 'combustionMaterial', labelWidth: '10em', width: '100%' },
      { label: '疏散出口及安全通道', value: 'exitPassage', labelWidth: '10em', width: '100%' }
    ];
  }
  render() {
    const { data } = this.state;
    const scenePicture = (data.scenePicture || '').split(',').filter(e => !!e);
    const appearanceImages = (data.appearanceImages || '').split(',').filter(e => !!e);
    const planeImages = (data.planeImages || '').split(',').filter(e => !!e);
    const rescueImages = (data.rescueImages || '').split(',').filter(e => !!e);
    const positionImages = (data.positionImages || '').split(',').filter(e => !!e);
    return (
      <div className="ccs-box">
        <div className="ccs-left-box ccs-scrollbar">
          <IconTitle title="基本信息" />
          <LabelValueFrame columns={this.renderBasic()} data={data} />
          <IconTitle title="运载能力" />
          <LabelValueFrame columns={this.renderRun()} data={data} />
          <IconTitle title="安全设施" />
          <LabelValueFrame columns={this.renderDescr()} data={data} />
        </div>
        <div className="ccs-right-box">
          <Tabs mode="line">
            <TabList>
     {/**  <Tab>现实场景图片</Tab>*/}
              <Tab>外观图</Tab>
              <Tab>平面图</Tab>
              <Tab>救援图</Tab>
              <Tab>方位图</Tab>
            </TabList>
            {/**  <TabPanel><Picture imgArr={scenePicture || []} length={scenePicture.length} /></TabPanel>*/}
            <TabPanel><Picture imgArr={appearanceImages || []} length={appearanceImages.length} /></TabPanel>
            <TabPanel><Picture imgArr={planeImages || []} length={planeImages.length} /></TabPanel>
            <TabPanel><Picture imgArr={rescueImages || []} length={rescueImages.length} /></TabPanel>
            <TabPanel><Picture imgArr={positionImages || []} length={positionImages.length} /></TabPanel>
          </Tabs>
        </div>
      </div>
    );

  }
}

export default Aircraft;
