import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { connectGlobalPage } from '@gm/graphmod-common';
import { MQTTProvider } from 'amos-mqtt';
import AlarmDangerLine from './side/AlarmDangerLine';
import RiskDegree from './side/RiskDegree';
import BasicInfo from './side/BasicInfo';
import MiddleIndex from './middle/index';
import './index.scss';

/**
 * 物联监控
 *
 * @class Content
 * @extends {Component}
 */
@connectGlobalPage({
  testDataConfig: {
    mqttUrl: 'ws://172.16.10.85:8083/mqtt' // 消息地址
  },
  testVisualParams: {
    theme: ''
  }
})
class Content extends Component {
  static propTypes = {
    dataConfig: PropTypes.object
  };

  constructor(props) {
    super(props);
    this.state = {

    };
  }

  render() {
    const { dataConfig = {} } = this.props;
    return (
      <MQTTProvider url={dataConfig.mqttUrl}>
        <div className="ccs-risk-situation on-risk-situation">
          <div className="ccs-risk-situation-side">
            <div className="ccs-risk-situation-left">
              <BasicInfo />
              <AlarmDangerLine />
            </div>
          </div>
          <div className="ccs-risk-situation-content">
            <MiddleIndex />
          </div>
          <div className="ccs-risk-situation-side">
            <div className="ccs-risk-situation-right">
              <RiskDegree />
            </div>
          </div>
        </div>
      </MQTTProvider>
    );
  }
}

export default Content;
