import React, { Component } from 'react';
import AmosEcharts from 'amos-viz/lib/echarts';
import { message, eventConsts } from '../../../eventConsts';
import {
  queryRiskSourceMatrixAction
} from './../../api';

class RpnPieChart extends Component {
  constructor(props) {
    super(props);
    this.state = {
      dataAll: [],
      dangerPoints: [],
      safePoints: [],
      warnPoints: [],
      code: (message.getStorageData(eventConsts.STATION_CODE) || {}).message
    };
  }

  componentDidMount() {
    this.getMessageData();
    this.onRequest();
  }

  getMessageData = () => {
    const me = this;
    message.storageSubscribe(eventConsts.STATION_CODE, (data) => {
      console.log('rpn底部折线');
      console.log(data);
      me.setState({
        code: data.message || '',
        dataAll: [],
        dangerPoints: [],
        safePoints: [],
        warnPoints: []
      },() => me.onRequest());
    });
  }

  onRequest = () => {
    console.log('发起请求');
    const { code } = this.state;
    queryRiskSourceMatrixAction(code).then(data => {
      // data = [
      //   { evaluationOid: '1', mutiby: 10, riskSourceId: '209', name: '屏柜', evaluationSid: '10' },
      //   { evaluationOid: '1', mutiby: 9, riskSourceId: '210', name: '设备室设备', evaluationSid: '6' }
      // ];
      data &&
        data.map(e => {
          this.classifyPoints(e);
        });
      let { dataAll, dangerPoints, safePoints, warnPoints } = this.state;
      dataAll.push(dangerPoints);
      dataAll.push(warnPoints);
      dataAll.push(safePoints);
      this.setState({
        dataAll
      });
    });
  }

  getOptions = () =>  {
    return {
      grid: [{ x: '8%', y: '13%', width: '77%', height: '75%' }],
      tooltip: {
        formatter: item => {
          let text = item.value;
          // console.log(JSON.stringify(item));
          return `${text[2]}<br>S:${text[0]}  O:${text[1]}`;
        }
      },
      color: ['green', '#D32029', '#ff6600'],
      xAxis: [
        {
          nameGap: 5,
          gridIndex: 0,
          min: 0,
          max: 10,
          name: 'S(严重度)',
          axisLabel: {
            textStyle: {
              color: 'white'
            }
          },
          nameTextStyle: {
            fontWeight: 'bold',
            fontSize: 15,
            color: 'white'
          },
          axisLine: {
            lineStyle: {
              color: '#fff'
            }
          }
        }
      ],
      yAxis: [
        {
          nameGap: 5,
          gridIndex: 0,
          min: 0,
          max: 10,
          name: 'O(故障率)',
          axisLabel: {
            textStyle: {
              color: 'white'
            }
          },
          axisLine: {
            lineStyle: {
              color: '#fff'
            }
          },
          nameTextStyle: {
            fontWeight: 'bold',
            fontSize: 15,
            color: 'white'
          }
        }
      ],
      // symbol: 'rect',
      legend: {
        textStyle: { // 图例文字的样式
          color: 'white'
        },
        top: 5,
        right: 100,
        selectedMode: false,
        data: ['最低线', '最高线', '']
      },
      series: this.getSeries()
    };
  }

  getSeries = () => {
    let series = [];
    let safetySeries = {
      name: '最低线',
      type: 'scatter',
      xAxisIndex: 0,
      yAxisIndex: 0,
      data: this.state.dataAll[2],
      markLine: this.markLineOpt('safety')
    };
    let dangerSeries = {
      name: '最高线',
      type: 'scatter',
      xAxisIndex: 0,
      yAxisIndex: 0,
      data: this.state.dataAll[0],
      markLine: this.markLineOpt('danger')
    };
    let warnSeries = {
      name: '111',
      type: 'scatter',
      xAxisIndex: 0,
      yAxisIndex: 0,
      data: this.state.dataAll[1]
    };
    series.push(safetySeries);
    series.push(dangerSeries);
    series.push(warnSeries);
    return series;
  }

  markLineOpt = (type) => {
    let data1 = [];
    let color = 'green';
    if (type === 'safety') {
      color = 'green';
      data1 = [
        {
          // eslint-disable-next-line no-magic-numbers
          coord: [7, 0],
          symbol: 'none'
        },
        {
          // eslint-disable-next-line no-magic-numbers
          coord: [0, 4],
          symbol: 'none'
        }
      ];
    } else if (type === 'danger') {
      color = '#D32029';
      data1 = [
        {
          // eslint-disable-next-line no-magic-numbers
          coord: [9, 0],
          symbol: 'none'
        },
        {
          // eslint-disable-next-line no-magic-numbers
          coord: [0, 8],
          symbol: 'none'
        }
      ];
    }
    return {
      animation: false,
      label: {
        normal: {
          formatter: '',
          textStyle: {
            align: ''
          }
        }
      },
      lineStyle: {
        normal: {
          type: 'solid',
          color
        }
      },
      tooltip: {
        formatter: ''
      },
      data: [data1]
    };
  }

  classifyPoints = (point) => {
    let { dangerPoints, safePoints, warnPoints } = this.state;
    let d = [];
    d.push(point.evaluationSid);
    d.push(point.evaluationOid);
    d.push(point.riskSourceName);
    // eslint-disable-next-line no-magic-numbers
    if (((8 * point.evaluationSid) + (9 * point.evaluationOid)) > 72) { // 红色区域：S>=9或O>=8 (直线右侧区域8x + 9y - 72 > 0)
      dangerPoints.push(d);
    // eslint-disable-next-line no-magic-numbers
    } else if (((4 * point.evaluationSid) + (7 * point.evaluationOid)) < 28) { // 绿色区域：S<7且O<4 (直线左侧区域4x + 7y - 28 < 0)
      safePoints.push(d);
    } else {// 橙色区域：S<9且O<8&&S>=7且O>=4
      warnPoints.push(d);
    }
    this.setState({
      dangerPoints,
      safePoints,
      warnPoints
    });
  }

  render() {
    const option = this.getOptions();
    return (
      <div className="ccs-risk-situation-left-chart">
        <AmosEcharts option={option} />
      </div>
    );
  }
}

export default RpnPieChart;
