import React, { Component } from 'react';
// import PropTypes from 'prop-types';
import Item from './item';
import {
  alarmDangerAction
} from './../api';

class AlarmDangerStatistics extends Component {
  constructor(props) {
    super(props);
    this.state = {
      alertCalled: []
    };
  }

  componentDidMount() {
    this.onRequest();
  }

  onRequest = () => {
    alarmDangerAction().then(d => {
      let data = [];
      if (d) {
        data = [
          {
            title: '今日告警数量',
            label: '今日告警数量',
            value: d.todayAddAlarm ? d.todayAddAlarm : 0
          },
          {
            title: '今日现有隐患',
            label: '今日现有隐患',
            value: d.todayAddDanger ? d.todayAddDanger : 0
          },
          {
            title: '本周告警数量',
            label: '本周告警数量',
            value: d.weekAddAlarm ? d.weekAddAlarm : 0
          },
          {
            title: '本周现有隐患',
            label: '本周现有隐患',
            value: d.weekAddDanger ? d.weekAddDanger : 0
          }
        ];
      }
      this.setState({ alertCalled: data || [] });
    });
  }


  render() {
    const { alertCalled = [] } = this.state;
    return (
      <div className="ccs-on-duty-dynamic-statistics" style={{ height: '94%' }} >
        <div className="ccs-on-duty-dynamic-statistics-head"> <span>告警隐患</span></div>
        <div className="ccs-on-duty-dynamic-statistics-content">
          {
            alertCalled.map(m => <Item key={m.title} title={m.label} total={m.value} />)
          }
        </div>

      </div>
    );
  }
}

export default AlarmDangerStatistics;
