import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { connectGlobalPage, FireTree } from '@gm/graphmod-common';
import MonitorContent from './MonitorContent';
import { buildVedioTreeAction } from './../api';
import { ScreenCard } from './../../common';
import { message, eventConsts } from './../../eventConsts';
import './index.scss';

/**
 * 视频监控
 *
 * @class VideoMonitor
 * @extends {Component}
 */
@connectGlobalPage({
  testDataConfig: {
    videoMore: false // 是否显示更多按钮
  }
})
class VideoMonitor extends Component {
  static propTypes = {
    dataConfig: PropTypes.object,
    oauthConfig: PropTypes.object,
    routeState: PropTypes.object
  };

  static contextTypes = {
    browserHistory: PropTypes.object
  };

  static defaultProps = {
    dataConfig: {},
    oauthConfig: {},
    routeState: {}
  };

  constructor(props) {
    super(props);
    this.rootData = { id: '-1', name: '全国', type: 'all' };
    this.state = {
      searchValue: '',
      expandedKeys: [],
      treeData: [], // 消防建筑树数据
      searchData: [], // 消防建筑树数据
      selectedKey: this.rootData.id, // 树选中节点key
      buildObj: this.rootData, // 树选中节点
      code: (message.getStorageData(eventConsts.STATION_CODE) || {}).message,
      stationData: message.getStorageData(eventConsts.STATION_CODE) || {}
    };
  }

  componentDidMount() {
    this.getMessageData();
    this.getFireEquipmentTreeData();
  }

  getMessageData = () => {
    message.storageSubscribe(eventConsts.STATION_CODE, (data) => {
      console.log(data);
      this.setState({
        code: data.message || '',
        treeData: [],
        searchData: [],
        stationData: data
      },() => this.getFireEquipmentTreeData());
    });
    message.storageSubscribe(eventConsts.SWITCH_WHOLE_COUNTRY_STATION, (data) => {
      console.log(data);
      data.message === 'all' && this.setState({
        code: '',
        treeData: [],
        searchData: []
      },() => this.getFireEquipmentTreeData());
    });
  }

  onTreeSelect = (selectedKey, selectedNode) => {
    console.log(selectedKey, selectedNode);
    this.setState({ selectedKey, buildObj: selectedNode });
  };

  onSearchChange = searchValue => {
    this.setState({ searchValue });
  };

  onSearch = () => {
    const { searchValue, treeData } = this.state;
    const { searchData, expandedKeys } =
      FireTree.getSearchData(searchValue, treeData, 'name', [this.rootData.id], 'id', this.state.expandedKeys, true) || {};
    this.setState({
      searchData,
      expandedKeys
    });
  };

  getFireEquipmentTreeData = () => {
    const { code } = this.state;
    buildVedioTreeAction(code || '').then(data => {
      let treeData = [];
      if (!code) {
        treeData = [
          {
            id: '-1',
            name: '全国',
            type: 'all',
            children: data
          }
        ];
        this.rootData = { id: '-1', name: '全国', type: 'all' };
      } else {
        treeData = data;
        this.rootData = { id: data[0].id, name: data[0].name || '' };
      }
      this.setState({
        treeData,
        searchData: treeData,
        selectedKey: this.rootData.id, // 树选中节点key
        buildObj: this.rootData // 树选中节点
      });
    }, this.onSearch);
  };

  // 根据code获取节点
  getTreeDataByCode = (code, data) => {
    let treeData = [];
    if (data && data.length > 0) {
      for (let item of data) {
        if (item.id === code) {
          treeData.push(item);
          this.rootData = item;
          return treeData;
        }
      }
    }
  }

  renderMenus = data => {
    return [];
  };

  renderIcon = data => {
    // if (data.instanceId === this.rootData.instanceId) {
    //   return ImageConsts.common.vedioRoot;
    // }
  };

  render() {
    const { searchData, selectedKey, expandedKeys, buildObj, searchValue, code, stationData } = this.state;
    return (

      <div className="ccs-video-monitor on-video-monitor">
        <div className="ccs-video-monitor-left">
          <div className="ccs-video-monitor-left-map">
            <FireTree
              treeKey="id"
              treeName="name"
              // renderName={d => `${d.name}(${d.total || 0})`}
              renderName={d => d.name}
              onExpandedRowsChange={e => this.setState({ expandedKeys: e })}
              expandedKeys={expandedKeys}
              alwaysExpandedKeys={[this.rootData.id]}
              selectedKeys={[selectedKey]}
              treeData={searchData}
              onSelect={this.onTreeSelect}
              onSearchChange={this.onSearchChange}
              onSearch={this.onSearch}
              searchValue={searchValue}
              renderMeuns={this.renderMenus}
              renderIcon={this.renderIcon}
            />
          </div>
          {
            // <ScreenCard title="视频监控">
            // </ScreenCard>
          }
        </div>
        <div className="ccs-video-monitor-right">
          <div className="ccs-video-monitor-right-map">
            <MonitorContent dataConfig={this.props.dataConfig} buildObj={buildObj} code={code} stationData={stationData} />
          </div>
        </div>
      </div>
    );
  }
}

export default VideoMonitor;
