import React, { Component } from 'react';
import { Select, Form, Slider } from 'amos-framework';
import { tools } from '@gm/graphmod-utils';
import Modal from './../modal';
import { formLayout } from './../form/FormUtils';
import './DownLoadQrCode.scss';


const Option = Select.Option;
const FormItem = Form.Item;
const imgTypes = {
  'png': 'image/png',
  'jpeg': 'image/jpeg',
  'bmp': 'image/bmp'
};
/**
 * 二维码下载
 *
 * @class DownLoadQrCode
 * @extends {Component}
 */
class DownLoadQrCode extends Component {

  constructor(props) {
    super(props);
    this.state = {
      visible: false,
      form: {
        type: 'png',
        size: 200
      },
      title: '',
      imgName: '',
      imgData: '',
      qrCode: ''
    };
  }
  /**
   * 打开弹框并初始化数据
   * @param {*} qrCode 二维码值
   * @param {*} title 弹框标题
   * @param {*} imgName 下载图片名称
   * @memberof DownLoadQrCode
   */
  onOpen = (qrCode, title, imgName, imgData) => {
    this.setState({ visible: true, imgName, value: qrCode, title, imgData });
    // qrCodeAction(qrCodeLink, { scene: qrCode, width: 400 }).then(d => {
    //   this.setState({ imgData: d });
    // })
  }

  onDownload = () => {
    if (!this.state.value) {
      return;
    }
    const { form, imgName, imgData } = this.state;
    tools.downloadIamge(imgData, imgName, form.size, form.size, imgTypes[form.type] || imgTypes.png);
    this.onCancel();
  }

  onCancel = () => {
    if (!this.state.value) {
      return;
    }
    this.setState({
      visible: false,
      form: {
        type: 'png',
        size: 200
      },
      title: '',
      imgName: '',
      imgData: '',
      qrCode: ''
    });
  }

  onChange = (varName, value) => {
    const { form } = this.state;
    form[varName] = value;
    this.setState({ form });
  }

  render() {
    const { visible, form, title, imgData } = this.state;
    return (
      <Modal
        modalClass="mods-com-qrdownload-wrapper"
        width={500}
        visible={visible}
        onCancel={this.onCancel}
        onOk={this.onDownload}
        okText="下载"
        title={`${title}下载` || '下载二维码'}
      >
        <div className="mods-com-qrdownload-container">
          <div className="mods-com-qrdownload-img" ref={node => this.qr = node} >
            <img src={imgData} alt="" style={{ width: form.size, height: form.size }} />
          </div>
          <div className="mods-com-qrdownload-setting">
            <Form className="mods-com-form-tablelist-filter-content" rules={{}} ref={e => this.form = e} model={form}>
              <FormItem className={formLayout('50', '4')} label={<span>格式</span>} field="type">
                <Select value={form.type} onChange={(e) => this.onChange('type', e)}>
                  {
                    Object.keys(imgTypes).map(e => (
                      <Option key={e} value={e}>{e}</Option>
                    ))
                  }
                </Select>
              </FormItem>
              <FormItem className={formLayout('50', '4')} label={<span>大小</span>} field="size">
                <Slider value={form.size} onChange={(e) => this.onChange('size', e)} min={30} max={400}  />
              </FormItem>
            </Form>
          </div>
        </div>
      </Modal>
    );
  }
}

export default DownLoadQrCode;
