import React from 'react';
import PropTypes from 'prop-types';
import { Button } from 'amos-framework';
import classnames from 'classnames';
import ImageConsts from '@gm/graphmod-assets';
import './FilterPane.scss';
/**
 * 公共列表页面-筛选面板容器
 *
 * @class FilterPane
 * @extends {Component}
 */
function FilterPane(props) {
  const { children, onReset, onSearch, show, onHide, className, style } = props || {};
  return (
    <div className={classnames('eb-com-filter-pane', className)} style={{ display: show ? 'block' : 'none', ...style || {} }}>
      <div className="eb-com-filter-pane-title">
        <span>筛选</span>
        {onHide && <img src={ImageConsts.common.right} onClick={onHide} alt="" />}
      </div>
      <div className="eb-com-filter-pane-content">
        {children}
      </div>
      <div className="eb-com-filter-pane-footer">
        <Button className={classnames('eb-com-filter-pane-btn', 'eb-com-filter-pane-reset-btn')} onClick={onReset}>重置</Button>
        <Button className={classnames('eb-com-filter-pane-btn', 'eb-com-filter-pane-search-btn')} onClick={onSearch}>查询</Button>
      </div>
    </div>
  );
}

FilterPane.propTypes = {
  style: PropTypes.object,
  className: PropTypes.any,
  children: PropTypes.any,
  show: PropTypes.bool,
  onReset: PropTypes.func,
  onSearch: PropTypes.func,
  onHide: PropTypes.func
};

FilterPane.defaultProps = {
  onReset() { },
  onSearch() { }
};

export default FilterPane;
