import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import './MoreRowOverFlowText.scss';
/**
 * 多行文本省略号
 *
 * @class MoreRowOverFlowText
 * @extends {PureComponent}
 */
class MoreRowOverFlowText extends PureComponent {

  static propTypes = {
    rowCont: PropTypes.number,
    lineHeight: PropTypes.number,
    className: PropTypes.string,
    children: PropTypes.any
  };

  static defaultProps = {
    rowCont: 1,
    lineHeight: 12
  };

  constructor(props) {
    super(props);
    this.state = {
      view: false
    };
  }

  componentDidMount() {
    this.setting();
  }

  componentDidUpdate() {
    this.setting();
  }

  setting = () => {
    const { rowCont, lineHeight } = this.props;
    if (this.content.clientHeight > lineHeight * rowCont) {
      this.setState({ view: true }, () => {
        this.content.style.lineHeight = `${lineHeight}px`;
        this.content.style.maxHeight = `${lineHeight * rowCont}px`;
      });
    } else {
      this.setState({ view: false });
    }
  }

  render() {
    const { children, className } = this.props;
    return (
      <div {...this.props} className={classnames(className, { 'clib-morerow-overflowtext': this.state.view })} >
        <div ref={node => this.content = node} >
          {children}
        </div>
      </div>
    );
  }
}

export default MoreRowOverFlowText;
