import React, { Component } from 'react';
import { Tooltip } from 'amos-framework';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import './btn.scss';
/**
 * 系统常用多组按钮
 *
 * @class BatchBtn
 * @extends {Component}
 */
class BatchBtn extends Component {

  static propTypes = {
    className: PropTypes.any,
    label: PropTypes.any, // 按钮左侧文本,
    data: PropTypes.array, // 按钮组数据
    activeBtn: PropTypes.string, // 上一次点击的按钮key及当前不能点击的按钮
    onClick: PropTypes.func // 按钮点击事件
  };

  static defaultProps = {
    className: '',
    data: []
  };

  constructor(props) {
    super(props);
    this.state = {

    };
  }


  render() {
    let { onClick, label, data, activeBtn, className } = this.props;
    const dataList = data.filter(e => !e.hide);
    if (label instanceof Array && label.length > 0) {
      let newLabel = '';
      data.map((e, index) => {
        if (!e.hide) {
          newLabel = `${newLabel}${newLabel ? '\\' : ''}${label[index]}`;
        }
        return e;
      });
      label = newLabel;
    }
    if (dataList.length === 0) {
      return null;
    }
    return (
      <div
        className={
          classnames('eb-batchbtn', 'eb-com-btn', className,
            { 'eb-batchbtn-more': dataList.length >= 1 },
          )
        }
      >
        {
          dataList.filter(e => !e.hide).map(e => (
            <div
              key={e.key}
              className={classnames('eb-btn-conent', { 'eb-btn-conent-disabled': e.key === activeBtn || e.disabled })}
              title={e.title}
              onClick={e.click ? e.click : e.key === activeBtn || e.disabled ? ()=>{} : (event) => onClick(e.key, event)}
            >
              <Tooltip title={e.title} direction="down" align="middle">
                <img src={e.icon} alt={e.title} />
              </Tooltip>
            </div>
          ))
        }
        {
          label &&
          <div className="eb-btn-label">{label}</div>
        }
      </div>
    );
  }
}

export default BatchBtn;
