import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import { Popover } from 'amos-framework';
import './btn.scss';
/**
 * 系统常用按钮
 *
 * @class Btn
 * @extends {Component}
 */
class Btn extends Component {

  static propTypes = {
    className: PropTypes.string,
    label: PropTypes.string, // 按钮左侧文本,
    title: PropTypes.string,
    hide: PropTypes.bool,
    popoverContent: PropTypes.any,
    disabled: PropTypes.bool, // 是否禁用按钮,
    icon: PropTypes.string, // 按钮图片,
    onClick: PropTypes.func // 按钮点击事件
  };

  static defaultProps = {
    label: ''
  };

  constructor(props) {
    super(props);
    this.state = {

    };
  }


  render() {
    const { onClick, label, icon, disabled, title, className, hide, popoverContent } = this.props;
    if (hide) {
      return null;
    }
    return (
      <div
        className={
          classnames('eb-btn', 'eb-com-btn', className)
        }
      >
        {
          popoverContent && !disabled ?  <Popover
            contentWrapClassName="eb-btn-popover-wrapper"
            content={popoverContent}
            direction="down"
          >
            <div
              className="eb-btn-conent"
              title={title || label}
            >
              <img src={icon} alt={label} />
            </div>
          </Popover> :
            <div
              className={
                classnames('eb-btn-conent', { 'eb-btn-conent-disabled': disabled }
                )}
              title={title || label}
              onClick={!disabled ? onClick : ()=>{}}
            >
              <img src={icon} alt={label} />
            </div>
        }
        {
          label &&
          <div className="eb-btn-label">{label}</div>
        }
      </div>
    );
  }
}

export default Btn;
