import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import { Pagination } from 'amos-antd';
import { tools } from '@gm/graphmod-utils';
import FireCard from './FireCard';
import './FireCardList.scss';

/**
 * 卡片分页列表
 *
 * @class FireCardList
 * @extends {Component}
 */
class FireCardList extends Component {
  static propTypes = {
    rowKey: PropTypes.any,
    dataSource: PropTypes.array,
    columns: PropTypes.func,
    total: PropTypes.number,
    current: PropTypes.number,
    pageSize: PropTypes.number,
    onPageChange: PropTypes.func,
    rowSelection: PropTypes.object,
    selectedRowKeys: PropTypes.array,
    onSelectChange: PropTypes.func,
    onClick: PropTypes.func,
    onDoubleClick: PropTypes.func,
    pagination: PropTypes.bool, // 是否分页
    dataConfig: PropTypes.object, // 参数配置对象
    multiSelect: PropTypes.bool, // 是否多选
    menus: PropTypes.array
  };

  static defaultProps = {
    columns() {},
    rowKey: 'id'
  };

  constructor(props) {
    super(props);
    this.state = {
      multiple: []
    };
  }

  componentWillReceiveProps(props) {
    if (this.props.selectedRowKeys.length !== props.selectedRowKeys) {
      this.setState({ multiple: props.selectedRowKeys });
    }
  }

  onPageSize = (page, pageSize) => {
    const { onPageChange, current } = this.props;
    let newPage = current;
    let newPageSize = this.props.pageSize;
    if (page !== undefined) {
      newPage = page;
    }
    if (pageSize !== undefined) {
      newPageSize = pageSize;
    }
    onPageChange && onPageChange(newPage, newPageSize);
  };

  handleChange = (e, rowKey, event) => {
    const { multiple } = this.state;
    const { multiSelect, onSelectChange, dataSource } = this.props;
    const multipleData = [];
    if (multiSelect) {
      multiple.includes(e[rowKey]) ? multiple.splice(multiple.indexOf(e[rowKey]), 1) : multiple.push(e[rowKey]);
      dataSource.forEach(element => {
        multiple.forEach(item => {
          if (item === element.id) {
            multipleData.push(element);
          }
        });
      });
      onSelectChange(multiple, multipleData, event);
      this.setState({ multiple });
    } else {
      onSelectChange([e[rowKey]], [e], event);
    }
  };

  render() {
    const { dataSource, rowKey, columns, onDoubleClick, total, pageSize, current, selectedRowKeys, onSelectChange, pagination = true } = this.props;
    const isNotShowPagination = this.props.dataConfig && this.props.dataConfig.isNotShowPagination ? this.props.dataConfig.isNotShowPagination : false;
    // const backgroundColor = this.props.dataConfig && this.props.dataConfig.backgroundColor ? this.props.dataConfig.backgroundColor : 'white';
    return (
      <div className="mods-com-firecard-table" onClick={tools.isClickBlankByClass(() => onSelectChange([], []), ['mods-com-firecard'])}>
        <div
          // style={{ height: isNotShowPagination === false ? 'calc(100% - 42px)' : '100%' }}
          className={classnames('mods-com-firecard-table-content', 'mod-com-scrollbar')}
        >
          {dataSource.map((e, index) => (
            <FireCard
              {...this.props}
              key={e[rowKey]}
              {...columns(e, index)}
              isSelect={selectedRowKeys.some(i => i === e[rowKey])}
              onClick={event => this.handleChange(e, rowKey, event)}
              onDoubleClick={event => onDoubleClick(e, event)}
            />
          ))}
        </div>
        {!isNotShowPagination || !pagination ? (
          <div />
        ) : (
          <div className="mods-com-firecard-table-footer">
            <Pagination
              total={total}
              showTotal={e => `共${e}条`}
              pageSize={pageSize}
              current={current}
              showQuickJumper
              showSizeChanger
              onShowSizeChange={this.onPageSize}
              onChange={this.onPageSize}
            />
          </div>
        )}
      </div>
    );
  }
}

export default FireCardList;
