import React, { Component } from 'react';
import PropTypes from 'prop-types';
import './index.scss';
import { Select } from 'amos-framework';
import arrowRight from '@gm/graphmod-assets/assets/common/arrow-right.png';

const Option = Select.Option;

class CommonCard extends Component {
  static defaultProps = {
    selectOptions: []
  };

  constructor(props) {
    super(props);
  }


  render() {
    const { title, children, hasMore, openMore, hasSelect, selectOptions, selectOnchange, hasTab, tabOptions, tabOnchange } = this.props;
    return (
      <div className="common-cards">
        <div className="card-content">
          <div className="card-title">
            <div className="title-left">
              <div>
                <div className="circle"/>
                <div className="circle"/>
              </div>
              {title}
            </div>
            {hasMore &&
            <div className="title-right" onClick={openMore}>
              <span>更多</span><img src={arrowRight} alt=""/>
            </div>}
            {hasSelect &&
            <Select className="video-select" searchable onChange={(value, item) => selectOnchange(value, item)}>
              <Option>项目筛选</Option>
              {selectOptions.map((item, index) =>
                <Option key={item.id} value={item.id}>{item.name}</Option>
              )}
            </Select>}
            {hasTab &&
            <div className="tab-container">
              {tabOptions.map((item, index) => <div
                onClick={() => tabOnchange(index)}
                className={item.select ? 'tab-item tab-item-select' : 'tab-item'}
                key={index}>{item.name}</div>)}
            </div>
            }
          </div>
          <div className="card-contain">
            {children}
          </div>
        </div>
      </div>
    );
  }
}

CommonCard.propTypes = {
  title: PropTypes.string,
  position: PropTypes.string,
  hasMore: PropTypes.bool,
  openMore: PropTypes.func,
  hasSelect: PropTypes.bool,
  selectOptions: PropTypes.array,
  selectOnchange: PropTypes.func,
  hasTab: PropTypes.bool,
  tabOptions: PropTypes.array,
  tabOnchange: PropTypes.func
};

export default CommonCard;
