import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { FormBuilder } from 'amos-designer';
import { utils } from 'amos-tool';
import formFields from './../formBuilder';

const fm = {
  ...FormBuilder.formFields,
  ...formFields
};

/**
 * 通用动态表单
 * @class DynamicForm
 * @extends {Component}
 */
class DynamicForm extends Component {

  processItemData = (item) => {
    const { disabled } = this.props;
    return {
      disabled,
      ...item,
      data: utils.isUndefined(item.data) || utils.isNull(item.data) ? {} : item.data,
      // formItemDescr 动态表单描述性信息，需要向后端发送完整的 formItemDescr
      block: item.block || item.formItemDescr?.block
    };
  }

  render() {
    return (
      <FormBuilder
        column={2}
        labelWidth="8em"
        formMapper={fm}
        processItemData={this.processItemData}
        {...this.props}
      />
    );
  }
}

DynamicForm.propTypes = {
  fields: PropTypes.array,
  disabled: PropTypes.bool
};

export default DynamicForm;
