import React from 'react';
import PropTypes from 'prop-types';
import { Search, FormBuilder, Connect } from 'amos-framework';
import imageStatic from '@gm/graphmod-assets';
import SelectModal from './SelectModal';

const BasicForm = FormBuilder.BasicForm;
const enhanceForm = Connect.enhanceForm;

/**
 * 输入地址，或者从地图选择地址
 * @class InputBitmap
 * @extends {BasicForm}
 */
@enhanceForm
class InputBitmap extends BasicForm {

  constructor(props) {
    super(props);
    this.state = {
      visible: false,
      value: props.value || props.defaultValue || ''
    };
  }

  componentWillReceiveProps(nextProps) {
    if (this.props.value !== nextProps.value){
      this.setState({
        value: nextProps.value
      });
    }
  }

  toggle = () => {
    this.setState(prevState => ({
      visible: !prevState.visible
    }));
  };

  handleChange = (e, value) => {
    this.setState({
      value
    });
    this.props.onChange && this.props.onChange(value);
  }

  cancel = () => {
    this.setState({
      visible: false
    });
  }

  render() {
    const cls = this.getClassNames('param-inputbitmap');
    const { value, visible } = this.state;

    return (
      <div className={cls}>
        <Search {...this.props} icon={imageStatic.common.poi} onIconClick={this.toggle} value={value} onChange={this.handleChange}/>
        <SelectModal visible={visible} onCancel={this.cancel} />
      </div>
    );
  }
}

InputBitmap.propTypes = {};

export default InputBitmap;
