import React from 'react';
import PropTypes from 'prop-types';
import { FormBuilder, Connect, Cascader } from 'amos-framework';
import { api } from '@gm/graphmod-utils';
import './index.scss';

const { getRegion } = api;

const BasicForm = FormBuilder.BasicForm;
const enhanceForm = Connect.enhanceForm;


/**
 * 省市区级联选择
 * 解决省省市区级联选择地址【比较有局限性】
 * @class Cascader
 * @extends {Component}
 */
@enhanceForm
class ReginCascader extends BasicForm {
  constructor(props) {
    super(props);
    this.state = {
      data: []
    };
  }

  componentDidMount() {
    getRegion().then(resp => {
      this.setState({
        data: resp
      });
    });

  }

  onChange =(value,item)=>{
    const { onChange } = this.props;
    onChange && onChange({ value, dataItem: item });
  }


  render() {
    const cls = this.getClassNames('param-treeselect');
    let { value = [] } = this.props;
    let {  data = [] } = this.state;
    return (
      <div className={cls}>
        <Cascader
          options={data}
          value={value}
          enableParent
          fieldNames={{ label: 'regionName', value: 'regionCode', children: 'children' }}
          onChange={this.onChange}
          placeholder="请选择" />
      </div>
    );
  }
}


ReginCascader.propTypes = {
  datas: PropTypes.array,
  onChange: PropTypes.func
};

export default ReginCascader;
