import React, { Component } from 'react';
import PropTypes from 'prop-types';
import formatUrl from 'amos-processor/lib/utils/urlFormat';
import { Modal, IFrame } from 'amos-framework';


const showLayerList = ['建筑物', '道路线', '机位号'];
class SelectModal extends Component {
  constructor(props) {
    super(props);
    this.state = {

    };
  }

  componentDidMount() {
    this.props.visible && this.onInit();
  }

  componentDidUpdate(prevProps, prevState) {
    if (prevProps.visible !== this.props.visible && this.props.visible) {
      this.onInit();
    }
  }

  onInit = () => {
    const { longitude, latitude } = this.props;
    this.ifr && this.ifr.contentWindow && this.ifr.contentWindow.postMessage(JSON.stringify({
      topic: `@map_SETTING_GET_LAN_LON`,
      data: { longitude, latitude }
    }), '*');
  }


  handleMessage = e => {
    if (e.data) {
      try {
        const messagData = JSON.parse(e.data);
        const { topic, data } = messagData || {};
        if (topic && topic === '@map_CLICK_MAP_LON_LAT') {
          !this.props.disabled && this.props.onChange(data);
        }
      } catch (error) {
        console.log();
      }
    }
  };

  handleCreated = (ifrDoc, ifr) => {
    this.ifrDoc = ifrDoc;
    this.ifr = ifr;
    window.addEventListener('message', this.handleMessage, false);
    // 主窗口向iframe窗口发送信息
    // this.ifr.contentWindow..postMessage('from main window', '*');;
  };

  handleLoaded = () => {
    const { longitude, latitude } = this.props;
    this.ifr.contentWindow.postMessage(JSON.stringify({
      topic: `@map_SETTING_GET_LAN_LON`,
      data: { longitude, latitude }
    }), '*');
    this.ifr.contentWindow.postMessage(JSON.stringify({
      topic: `@map_MAP_LAYER_SHOW`,
      data: showLayerList
    }), '*');
  }

  renderContent() {
    const { url, longitude, latitude } = this.props;
    return (
      <div className="mods-inputpoi-content">
        <div className="mods-inputpoi-values">
          经纬度
          <input disabled type="number" value={longitude} />
          <input disabled type="number" value={latitude} />
        </div>
        <div className="mods-inputpoi-map">
          <IFrame
            url={formatUrl(`${url}?mapId=390`, location)}
            display
            scrolling="no"
            onMessage={this.handleMessage}
            onCreated={this.handleCreated}
            onLoaded={this.handleLoaded}
          />
        </div>
      </div>
    );
  }

  render() {
    const { visible, onCancel } = this.props;
    return (
      <Modal
        noDefaultHeader
        fullscreen
        className="mods-inputpoi-modal"
        width={700}
        visible={visible}
        noDefaultFooter
        onCancel={onCancel}
        content={this.renderContent()}
      />
    );
  }
}

SelectModal.propTypes = {
  visible: PropTypes.bool,
  url: PropTypes.string,
  longitude: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
  latitude: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
  width: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
  height: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
  onCancel: PropTypes.func,
  onChange: PropTypes.func,
  disabled: PropTypes.bool
};

export default SelectModal;
