import React from 'react';
import { FormBuilder, Connect } from 'amos-framework';
import { TreeSelect } from 'amos-antd';
import './index.scss';

const BasicForm = FormBuilder.BasicForm;
const enhanceForm = Connect.enhanceForm;

/**
 * TreeSelect (antd)
 * 下拉树
 * @class TreeSelect
 * @extends {Component}
 */
@enhanceForm
class AntdTreeSelect extends BasicForm {
  constructor(props) {
    super(props);
  }

  handleChange = (value) => {
    const { onChange } = this.props;
    onChange(value);
  }

  render() {
    const cls = this.getClassNames('param-treeselect');
    let { data = [], value, disabled, maxHeight } = this.props;
    const { items = [] } = data;
    return (
      <div className={cls}>
        <TreeSelect
          allowClear
          value={value}
          dropdownStyle={{ maxHeight: maxHeight || 400, overflow: 'auto' }}
          treeData={items}
          showSearch
          disabled={disabled}
          treeNodeFilterProp="title"
          treeNodeLabelProp="showLabel"
          filterTreeNode={(inputValue, treeNode) => treeNode.props.title.toLocaleLowerCase().includes(inputValue.toLocaleLowerCase())}
          onChange={(e) => this.handleChange(e)}
        />
      </div>
    );
  }
}

export default AntdTreeSelect;
