import React from 'react';
import { FormBuilder, Connect, Select } from 'amos-framework';
import { request, gateWay } from '@gm/graphmod-utils';

const {
  completePrefix,
  commonGet
} = request;

const BasicForm = FormBuilder.BasicForm;
const enhanceForm = Connect.enhanceForm;
const Option = Select.Option;
/**
 * 延迟加载select
 * @class selectDelay
 * @extends {BasicForm}
 */
@enhanceForm
class selectDelay extends BasicForm {

  constructor(props) {
    super(props);
    this.state = {
      dateList: [], // 政治面貌列表
      value: props.value || props.defaultValue || ''
    };
  }

  componentDidMount() {
    commonGet(completePrefix()(gateWay.jcs, this.props.url)).then(d => {
      this.props.data.items = d;
      this.setState({ dateList: d || [] });
    });
  }

  componentDidUpdate(prevProps, prevState) {
    if (prevProps.value !== this.props.value) {
      this.setValue();
    }
  }

  setValue = () => {
    this.setState({ value: this.props.value });
  }

  handleChange = (value) => {
    // debugger
    this.setState({
      value
    });
    this.props.onChange && this.props.onChange(value);
  }

  render() {
    const { dateList, value } = this.state;
    return (
      <Select
        value={value}
        popoverClassName="ts-select-popover"
        searchable onChange={(e) => this.handleChange(e)}>
        {dateList.map(item => <Option key={item.id} value={item.name}>{item.name}</Option>)}
      </Select>
    );
  }
}

selectDelay.propTypes = {};

export default selectDelay;
