import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal, Button } from 'amos-framework';
import './modal.scss';

/**
 * 公共的配置弹框
 *
 * @class CommonModal
 * @extends {DefaultNode}
 */
class CommonModal extends Component {

  static propTypes = {
    width: PropTypes.number,
    children: PropTypes.node,
    title: PropTypes.any,
    onCancel: PropTypes.func,
    modalClass: PropTypes.string,
    visible: PropTypes.bool,
    footer: PropTypes.any,
    noOverflow: PropTypes.bool,
    onOk: PropTypes.func,
    floorNode: PropTypes.any,
    okText: PropTypes.string,
    cancelText: PropTypes.string
  };

  static defaultProps = {
    width: 720,
    children: <div />,
    onCancel(){},
    onOk(){},
    okText: '确定',
    cancelText: '取消'
  };

  constructor(props) {
    super(props);

  }

  handleOK = (e) => {
    // 阻止弹框中回车提交表单问题
    e && e.preventDefault();
    this.props.onOk(e);
  }

  render() {
    const { title, visible, noOverflow, okText, cancelText, modalClass, onCancel, width, children, footer, floorNode, ...other } = this.props;
    return (
      <Modal
        {...other}
        header={title}
        width={width}
        visible={visible}
        dragable
        className={`eb-modal ${noOverflow ? 'no-overflow' : ''} ${modalClass || ''}`}
        onCancel={onCancel}
        onOk={this.handleOK}
        outterClosable={false}
        content={visible ? children : <div />}
        footer={!footer ?
          <div>
            {
              floorNode
            }
            <Button className="eb-modal-save" onClick={this.handleOK}>{okText || '确定'}</Button>
            <Button className="eb-modal-cancel" onClick={onCancel}>{cancelText || '确定'}</Button>
          </div> : footer
        }
      />
    );
  }
}

export default CommonModal;
