import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Overlay } from 'amos-framework';
import classnames from 'classnames';

/**
 * 浮层页面弹窗
 *
 * @class OverLayNotHeader
 * @extends {Component}
 * 使用:
 * <OverLay
 * visible={visible} 是否显示
 * content={content} 内容区域
 * className={className} 样式
 * />
 */
class OverLayNotHeader extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: this.props.visible || false,
      masked: false
    };
  }

  render() {
    const { masked } = this.state;
    const { visible, content, className = {}, style = {} } = this.props || {};
    return (
      <div className={classnames('overlay', className)}>
        <Overlay usePortal={false} style={{ backgroundColor: '#ffffff', zIndex: 1, ...style }} visible={visible} masked={masked}>
          <div style={{ margin: '0' }}>
            <div className="overlay-content">{content}</div>
          </div>
        </Overlay>
      </div>
    );
  }
}

OverLayNotHeader.propTypes = {
  visible: PropTypes.bool,
  content: PropTypes.object,
  className: PropTypes.string,
  style: PropTypes.object
};

export default OverLayNotHeader;
