import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { Tabs } from 'amos-framework';
import { GraphIcon, briskConfirmTip, BarBtnGroup, IconBtnOne } from 'amos-designer';

const { TabList, Tab, TabPanel } = Tabs;
/**
 * 通用 添加编辑详情页面, 默认添加返回，保存和tab页
 * @class CommonHeader
 * @extends {Component}
 */
class MgmtPage extends Component {
  static contextTypes = {
    browserHistory: PropTypes.object
  };

  handleBack = () => {
    const { noChange } = this.props;
    if (noChange) {
      this.context.browserHistory.goBack();
    } else {
      briskConfirmTip('是否关闭当前页面(您所修改的信息将不会保存)?', { frostedProps: true }).then(() => {
        this.context.browserHistory.goBack();
      });
    }
  }

  render() {
    const { className, pageType, tabs, onBack, activeKey, btns, onActive, onUpdatePage, onSave, onFilter, filterVisible, editBtn } = this.props;
    const { parentOauthConfig: { add: parentAdd  = true } = {} } = this.props;
    const cls = classNames('gm-mgmtpage', className);
    return (
      <Tabs loadAllPanel className={cls} mode="unbulge" activeKey={activeKey} onChange={onActive}>
        <TabList>
          <div className="gm-mgmtpage-leftbtns">
            <BarBtnGroup>
              <IconBtnOne onClick={onBack || this.handleBack} icon={<GraphIcon icon="/public/webico/function/层级-上一级.png" />} />
            </BarBtnGroup>
          </div>
          {
            (tabs || []).map(e =>
              e && !e.hideTab && <Tab key={e.key} activeKey={e.key}>{e.title}</Tab>
            )
          }
          {filterVisible ? <div className="gm-mgmtpage-rightbtns">
            <BarBtnGroup><IconBtnOne title="筛选" onClick={onFilter} icon={<GraphIcon icon="/public/webico/function/筛选.png" />} /></BarBtnGroup>
          </div> :
            <div className="gm-mgmtpage-rightbtns">
              {btns}
              {
                parentAdd && (
                  (onUpdatePage || onSave) && <BarBtnGroup>
                    {pageType === 'look' && editBtn !== 'edit' &&
                      <IconBtnOne title="编辑" onClick={onUpdatePage} icon={<GraphIcon icon="/public/webico/function/编辑-修改.png" />} />}
                    {pageType !== 'look' && !filterVisible && <IconBtnOne onClick={onSave} icon={<GraphIcon icon="/public/webico/function/保存-保存.png" />} />}
                  </BarBtnGroup>)
              }
            </div>
          }
        </TabList>
        {
          (tabs || []).map(e =>
            e && <TabPanel key={e.key} activeKey={e.key}>
              {e.component}
            </TabPanel>
          )
        }
      </Tabs>
    );
  }
}

MgmtPage.propTypes = {
  editBtn: PropTypes.string,
  className: PropTypes.string,
  tabs: PropTypes.array,
  btns: PropTypes.node,
  onBack: PropTypes.func,
  onUpdatePage: PropTypes.func,
  activeKey: PropTypes.string,
  noChange: PropTypes.string,
  onActive: PropTypes.func,
  onSave: PropTypes.func,
  onFilter: PropTypes.func,
  filterVisible: PropTypes.bool,
  parentOauthConfig: PropTypes.object,
  pageType: PropTypes.oneOf(['edit', 'look', 'add'])
};

export default MgmtPage;
