import React, { Component } from 'react';
import PropTypes from 'prop-types';
import moment from 'moment';
import DetailPane from './DetailPane';
import DetailsList from './DetailsList';
/**
 *
 *
 * @class BizTableDetail
 * @extends {Component}
 */
class BizTableDetail extends Component {
  static propTypes = {
    data: PropTypes.object,
    show: PropTypes.bool,
    detailSetting: PropTypes.array,
    onShowDetail: PropTypes.func
  };

  static defaultProps = {
    data: {},
    detailSetting: [],
    detailSettingOther: {}
  };

  constructor(props) {
    super(props);
    this.state = {

    };
  }

  renderItem = (item) => {
    return <div className="detail-item">
      <div className="detail-name omission">{item.name}：</div>
      <div className="detail-value omission">{item.value}</div>
    </div>;
  }

  render() {
    const { show, onShowDetail, data, detailSetting } = this.props;
    return (
      <DetailPane className="gm-tablepage-details gm-tablepage-scrollbar" show={show} onHide={onShowDetail} >
        <div className="gm-tablepage-details-content">
          {
            (data[detailSetting.imageKey] || detailSetting.defaultImage) &&
            <div className="gm-tablepage-details-img">
              <div className="gm-tablepage-details-img-centent">
                <img src={data[detailSetting.imageKey] || detailSetting.defaultImage} alt="" />
              </div>
            </div>
          }
          {
            data[detailSetting.titleKey] &&
            <div className="gm-tablepage-details-name">
              <label>{data[detailSetting.titleKey]}</label>
            </div>
          }
          {
            data[detailSetting.dateKey] &&
            <div className="gm-tablepage-details-date">
              <span>
                {
                  data[detailSetting.dateKey] ?
                    moment(data[detailSetting.dateKey], 'YYYY-MM-DD HH:mm:ss').format(detailSetting.dateFormat || 'YYYYMMDD')
                    : ''
                }
              </span>
            </div>
          }
          <div className="gm-tablepage-details-form">
            <DetailsList data={data} detailSetting={detailSetting.formInfos} />
          </div>
        </div>
        {detailSetting.renderOther && detailSetting.renderOther(data)}
      </DetailPane>
    );
  }
}

export default BizTableDetail;
