import React, { Component } from 'react';
import PropTypes from 'prop-types';
import moment from 'moment';
import { Button, Divider } from 'amos-framework';
import ImageConsts from '@gm/graphmod-assets';
import DetailsList from './../biz/DetailsList';
import './FireDetailsPane.scss';
/**
 * 消防详情面板
 *
 * @class FireDetailsPane
 * @extends {Component}
 */
class FireDetailsPane extends Component {
  static propTypes = {
    renderConfig: PropTypes.func,
    name: PropTypes.string,
    date: PropTypes.string,
    total: PropTypes.number,
    selectTotal: PropTypes.number,
    icon: PropTypes.any,


    defaultIcon: PropTypes.any,
    info: PropTypes.object,
    title: PropTypes.string,
    showTotal: PropTypes.bool,
    renderTopContent: PropTypes.func,
    renderExtraContent: PropTypes.func,
    systemPicListFlag: PropTypes.bool, // 系统图调用标志
    systemPicList: PropTypes.array, // 系统图该系统已有的设备数据
    updateDataList: PropTypes.func, // 设备 加入/移除 更新父页面列表数据
    categoryObj: PropTypes.object, // 选中的当前组织节点
    treeData: PropTypes.array// 组织树结构
  };

  static defaultProps = {
    renderConfig() { },
    total: 0,
    selectTotal: 0,
    info: {},
    defaultIcon: ImageConsts.common.defaultCard
  };

  constructor(props) {
    super(props);
    this.state = {
      systemPicList: this.props.systemPicList
    };
  }

  // 判断设备是否再该系统数据中
  processAddEquip = () => {
    const { systemPicList } = this.state;
    const { info, systemPicListFlag } = this.props;
    if (systemPicListFlag) {
      if (systemPicList.length > 0 && systemPicList.findIndex(item => item.id === info.id) > -1) {
        return <Button onClick={() => this.systemPicAddData('del', systemPicList, info)}>移出当前消防系统</Button>;
      }
      return <Button onClick={() => this.systemPicAddData('add', systemPicList, info)}>加入当前消防系统</Button>;
    }
    return '';
  };

  // 设备的添加 移除
  systemPicAddData = (flag, systemPicList, info) => {
    console.log('info=====>', info);
    if (flag === 'add') {
      const obj = { index: systemPicList.length + 1, id: info.id, equipName: info.name, equipType: info.type, equipCode: info.qrcode, updatePerson: '李斯' };
      systemPicList.push(obj);
    } else {
      systemPicList = systemPicList.filter(item => item.id !== info.id);
    }
    this.setState({ systemPicList });
    this.props.updateDataList(systemPicList);
  };

  render() {
    const { renderConfig, name, date, total, selectTotal, icon, info, title, defaultIcon, renderExtraContent, renderTopContent } = this.props;
    if (selectTotal === 1) {
      const list = renderConfig(info);
      let noeGroupList = [];
      let groupObj = {};
      list.map(e => {
        if (e.group) {
          if (groupObj[e.group]) {
            groupObj[e.group].push(e);
          } else {
            groupObj[e.group] = [e];
          }
        } else {
          noeGroupList.push(e);
        }
        return e;
      });
      if (renderExtraContent || renderTopContent) {
        return (
          <div className="mod-com-scrollbar">
            <div className="mods-com-firepanal-details-pane mod-com-scrollbar">
              {renderTopContent ? renderTopContent() :
                <div>
                  <div className="mods-com-firepanal-details-img">
                    <div className="mods-com-firepanal-details-img-centent">
                      <img src={icon || defaultIcon} style={{ borderWidth: icon ? '1px' : 0 }} alt="" />
                    </div>
                    <div className="mods-com-firepanal-details-form">
                      <DetailsList data={info} configs={noeGroupList} />
                    </div>
                  </div>
                  <div className="mods-com-firepanal-details-name">
                    <label>{name}</label>
                  </div>
                  <div className="mods-com-firepanal-details-date">
                    <span>{date}</span>
                  </div>
                  {Object.keys(groupObj).map(e => (
                    <fragment key={e}>
                      <div className="mods-com-firepanal-details-title">{e}</div>
                      <div className="mods-com-firepanal-details-form">
                        <DetailsList data={info} configs={groupObj[e]} />
                      </div>
                    </fragment>
                  ))}
                </div>
              }
            </div>
            {renderExtraContent && <Divider />}
            {renderExtraContent && renderExtraContent()}
          </div>
        );
      } else {
        return (
          <div className="mods-com-firepanal-details-pane mod-com-scrollbar">
            <div className="mods-com-firepanal-details-img">
              <div className="mods-com-firepanal-details-img-centent">
                <img src={icon || defaultIcon} style={{ borderWidth: icon ? '1px' : 0 }} alt="" />
              </div>
            </div>
            <div className="mods-com-firepanal-details-name">
              <label>{name}</label>
            </div>
            <div className="mods-com-firepanal-details-date">
              <span>{date ? moment(date, 'YYYY-MM-DD HH:mm:ss').format('YYYYMMDD') : ''}</span>
            </div>
            <div className="mods-com-firepanal-details-form">
              <DetailsList data={info} configs={noeGroupList} />
            </div>
            {Object.keys(groupObj).map(e => (
              <fragment key={e}>
                <div className="mods-com-firepanal-details-title">{e}</div>
                <div className="mods-com-firepanal-details-form">
                  <DetailsList data={info} configs={groupObj[e]} />
                </div>
              </fragment>
            ))}
            {this.processAddEquip()}
          </div>
        );
      }
    } else {
      return (
        <div className="mods-com-firepanal-details-pane mod-com-scrollbar">
          <div className="mods-com-firepanal-details-img">
            <div className="mods-com-firepanal-details-img-centent">
              <img src={defaultIcon || icon} style={{ borderWidth: icon ? '1px' : 0 }} alt="" />
            </div>
          </div>
          <div className="mods-com-firepanal-details-name">
            {selectTotal === 0 && (
              <label>
                共{total}个{title || ''}
              </label>
            )}
            {selectTotal > 1 && (
              <label>
                已选择{selectTotal}个{title || ''}
              </label>
            )}
          </div>
        </div>
      );
    }
  }
}

export default FireDetailsPane;
