import React, { Component } from 'react';
import PropTypes from 'prop-types';
import ImageConsts from '@gm/graphmod-assets';
import { getSceneValue } from 'amos-designer';
import BatchBtn from './../btns/BatchBtn';
import Btn from './../btns/Btn';
import SplitPane from './../splitPane';
import FireFilter from './FileFilter';
import FireDetailsPane from './FireDetailsPane';
import './FirePanel.scss';

const defaultSize = 230;

/**
 * 消防面板
 *
 * @class FirePanal
 * @extends {Component}
 */
class FirePanal extends Component {

  static propTypes = {
    viewList: PropTypes.array,
    leftOther: PropTypes.any,
    rightOther: PropTypes.any,
    onHideGroup: PropTypes.func,
    onLookWayChange: PropTypes.func,
    panelMap: PropTypes.object,
    filterProps: PropTypes.object,
    detailsProps: PropTypes.object,
    isBatch: PropTypes.bool,
    handleBatchStamp: PropTypes.func,
    batchValue: PropTypes.bool, // 是否选择全选按钮
    isCarShow: PropTypes.string,
    isNotShowPagination: PropTypes.bool,
    hidebut: PropTypes.bool,
    style: PropTypes.object
  };

  static defaultProps = {
    filterProps: {},
    onHideGroup(){},
    detailsProps: {},
    viewList: [
      { key: 'cardList', title: '卡片', icon: ImageConsts.common.imageView }
      // { key: 'tableList', title: '列表', icon: ImageConsts.common.listView }
    ]
  };

  constructor(props) {
    super(props);
    this.state = {
      lookWay: props.viewList[0].key,
      hideDetails: false,
      showFilter: false,
      test: true
    };
  }
  /**
   * 中间列表区域展示方式切换
   * @param {*} lookWay 展示方式
   * @memberof FileMgmt
   */
  handleLookWayChange = (lookWay) => {
    this.setState({ lookWay });
  }
  /**
   * 是否显示右侧详情或筛选
   *
   * @memberof FirePanal
   */
  handleHideDetails = () => {
    this.setState({ hideDetails: !this.state.hideDetails });
  }
  /**
   * 显示隐藏过滤条件
   * @memberof FirePanal
   */
  handleShowFilter = () => {
    this.setState({ showFilter: !this.state.showFilter });
  }

  handleBatchStamp = (val) =>{
    this.props.handleBatchStamp(val);
  }

  render() {
    const { panelMap, leftOther, rightOther, viewList, onHideGroup, onLookWayChange,
      filterProps, detailsProps,isBatch, batchValue,isCarShow,hidebut, style
    } = this.props;
    const { lookWay, hideDetails, showFilter } = this.state;
    const isNotShowPagination = getSceneValue(this.props, 'isNotShowPagination', false);
    return (
      <div className="mods-com-firepanal">
        {!isCarShow && <div className="mods-com-firepanal-header">
          <div className="mods-com-firepanal-leftbtns">
            {
              viewList.length > 1 && <BatchBtn
                data={viewList}
                label="查看"
                activeBtn={lookWay}
                onClick={onLookWayChange}
              />
            }
            <BatchBtn
              data={hidebut ?
                [
                  { key: 'details', title: '显示详情', click: this.handleHideDetails, icon: ImageConsts.common.hideDetails }
                ] : [
                  { key: 'group', title: '显示分类', click: onHideGroup, icon: ImageConsts.common.hideTree },
                  { key: 'details', title: '显示详情', click: this.handleHideDetails, icon: ImageConsts.common.hideDetails }
                ]}
              label="视图"
            />
            {isBatch &&
              <div>
                <input type="checkbox" checked={batchValue} onChange={(e)=> this.handleBatchStamp(e.target.checked)}/> 全选
              </div>}
            { leftOther }
          </div>
          <div style={{ 'flex': '1' }} />
          <div className="mods-com-firepanal-rightbtns">
            { rightOther }
            { !filterProps.hideFilterBtn && <Btn label="筛选" onClick={this.handleShowFilter} icon={ImageConsts.common.filter} />}
          </div>
        </div> }
        <div className="mods-com-firepanal-content" style={{ height: isNotShowPagination === true ? 'calc(100% - 42px)' : '100%' }}>
          <SplitPane
            style={style}
            mainPaneIndex={0}
            mainPaneMinSize={296}
            secondaryDefaultSize={detailsProps.detailPanelDefaultSize || defaultSize}
            secondaryMinSize={detailsProps.detailPanelDefaultSize || defaultSize}
          >
            <div className="mods-com-firepanal-page">
              {
                panelMap[lookWay]
              }
            </div>
            {
              !isCarShow && (!hideDetails || showFilter) && <div className="mods-com-firepanal-sebar">
                {
                  showFilter ?
                    <FireFilter
                      className="mods-com-firepanal-filter"
                      onShowFilter={this.handleShowFilter}
                      show={showFilter}
                      {...filterProps}
                    /> :
                    <FireDetailsPane
                      className="mods-com-firepanal-details"
                      {...detailsProps}
                    />
                }
              </div>
            }
          </SplitPane>
        </div>
      </div>
    );
  }
}

export default FirePanal;
