import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Select, Input } from 'amos-antd';
import './style.scss';

const Option = Select.Option;

/**
 * 搜索框
 *
 * @class Search
 * @extends {Component}
 */
class CheckedSearch extends Component {

  static propTypes = {
    value: PropTypes.string,
    onSearch: PropTypes.func,
    placeholder: PropTypes.string,
    noBlurSearch: PropTypes.bool,
    options: PropTypes.array,
    defaultSelect: PropTypes.string,
    onHandleSearch: PropTypes.func,
    onSelectSearch: PropTypes.func
  };

  static defaultProps = {
    onSearch(){},
    placeholder: '搜索',
    options: [],
    defaultSelect: '全部'
  };

  constructor(props) {
    super(props);

  }

  onClick = (e) => {
    e.stopPropagation();
    this.props.onSearch(this.input.input.value);
  }

  handleChange = () => {

  }

  render() {
    const { onHandleSearch, onSelectSearch, placeholder, defaultSelect, options, noBlurSearch, ...other } = this.props;

    if (options.length === 0) {
      return null;
    }

    return (
      <div className="mods-com-search">
        <div className="search-selected">
          <span>类型：</span>
          <Select defaultValue={defaultSelect} style={{ width: 120, fontSize: '12px' }} onChange={onSelectSearch}>
            {
              options.map(e => (
                <Option value={e.value} key={e.value}> {e.title} </Option>
              ))
            }
          </Select>
        </div>

        <div className="search-input">
          <Input
            ref={node => this.input = node}
            placeholder={placeholder}
            {...other}
            onPressEnter={onHandleSearch}
            onBlur={(e) => { e.stopPropagation(); !noBlurSearch && onHandleSearch; }}
          />
        </div>
      </div>
    );
  }
}

export default CheckedSearch;
