import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Input } from 'amos-antd';
import ImageConsts from '@gm/graphmod-assets';
import './style.scss';
/**
 * 搜索框
 *
 * @class Search
 * @extends {Component}
 */
class Search extends Component {

  static propTypes = {
    value: PropTypes.string,
    onSearch: PropTypes.func,
    placeholder: PropTypes.string,
    noBlurSearch: PropTypes.bool
  };

  static defaultProps = {
    onSearch(){},
    placeholder: '搜索'
  };

  constructor(props) {
    super(props);

  }

  onClick = (e) => {
    e.stopPropagation();
    this.props.onSearch((this.input.input.value || '').trim());
  }

  render() {
    const { onSearch, value, placeholder, noBlurSearch, ...other } = this.props;
    return (
      <div className="mods-com-search">
        <img onClick={this.onClick} src={ImageConsts.common.search} alt="" />
        <Input
          {...other}
          ref={node => this.input = node}
          placeholder={placeholder}
          {...(value ? { value } : {})}
          onChange={(e)=>onSearch(e.target.value, true)}
          onPressEnter={(e) => onSearch((e.target.value || '').trim())}
          onBlur={(e) => { e.stopPropagation(); !noBlurSearch && onSearch((e.target.value || '').trim()); }}
        />
      </div>
    );
  }
}

export default Search;
