import React, { Component } from 'react';
import PropTypes from 'prop-types';

/**
 * 重命名输入框
 *
 * @class RenameInput
 * @extends {Component}
 */
class RenameInput extends Component {

  static propTypes = {
    onOk: PropTypes.func, // 回车或失去焦点
    defaultValue: PropTypes.string
  };

  static defaultProps = {
    onOk(){}
  };

  constructor(props) {
    super(props);
    this.state = {

    };
  }

  componentDidMount() {
    this.node.select();
  }

  render() {
    const { onOk, defaultValue, ...other } = this.props;
    return (
      <input
        ref={node => this.node = node}
        defaultValue={defaultValue}
        onBlur={(event)=>onOk(event)}
        onKeyPress={(event) => event.key === 'Enter' && onOk(event)}
        {...other}
      />
    );
  }
}

export default RenameInput;
