import { request } from '@gm/graphmod-utils';

const { commonGet, formatUrl } = request;

export const UrlConsts = {};


/**
 * 查询用户列表
 * @param url 路径
 * @param keyword 关键字
 */
export const searchUser = (url, keyword) => {
  return commonGet(formatUrl(url, { name: keyword }));
};

/**
 * 查询用户-组织树结构
 * @param url 路径
 */
export const getUserTree = url => {
  return commonGet(formatUrl(url, {}));
};
