import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import ImageConst from '@gm/graphmod-assets';

const numWidth = 7; // 一个数字的宽度
const one = 1;
const four = 4;
const nine = 9;
/**
 * 视频矩阵分页
 *
 * @class MatrixPagination
 * @extends {Component}
 */
class MatrixPagination extends Component {

  static propTypes = {
    other: PropTypes.any,
    page: PropTypes.number,
    hideSize: PropTypes.bool,
    hideLabel: PropTypes.bool,
    total: PropTypes.number,
    size: PropTypes.number,
    onPageChange: PropTypes.func
  };

  static defaultProps = {
    total: 0,
    page: 1,
    size: 4,
    onPageChange() { }
  };

  constructor(props) {
    super(props);
    this.state = {

    };
  }

  handleChange = (page, size) => {
    if (page !== this.props.page || size !== this.props.size) {
      const pages = Math.ceil(this.props.total / size);
      if (page < 1) {
        page = 1;
      }
      if (page > pages) {
        page = pages;
      }
      this.props.onPageChange(page, size);
    }
  }

  render() {
    const { other, page, size, total, hideSize, hideLabel } = this.props;
    let pages = Math.ceil(total / size);
    pages = pages > 0 ? pages : 1;
    return (
      <div className="modcom-matrixpagination">
        <div className="modcom-matrixpagination-btngroup">
          <div className="modcom-matrixpagination-btn" onClick={() => this.handleChange(1, size)}>
            <img src={ImageConst.common.vedioStart} alt="" />
          </div>
          <div className="modcom-matrixpagination-btn" onClick={() => this.handleChange(page - 1, size)}>
            <img src={ImageConst.common.vedioPrev} alt="" />
          </div>
          <div className="modcom-matrixpagination-pagenum">
            <input
              min={1}
              value={page}
              onBlur={(e) => this.handleChange(Number(e.target.value || '1'), size)}
              max={pages}
              style={{ width: String(pages).length * numWidth }}
              type="number"
            />
            <label> / </label>
            <span style={{ width: String(pages).length * numWidth }}>{pages}</span>
          </div>
          <div className="modcom-matrixpagination-btn" onClick={() => this.handleChange(page + 1, size)}>
            <img src={ImageConst.common.vedioNext} alt="" />
          </div>
          <div className="modcom-matrixpagination-btn modcom-matrixpagination-btn-last" onClick={() => this.handleChange(pages, size)}>
            <img src={ImageConst.common.vedioEnd} alt="" />
          </div>
          {!hideLabel && <span>翻页</span>}
        </div>
        <div className="modcom-matrixpagination-other">
          {other}
        </div>
        {
          !hideSize &&
          <div className="modcom-matrixpagination-btngroup">
            <div
              className={classnames('modcom-matrixpagination-btn', { 'modcom-matrixpagination-btn-active': size === one })}
              onClick={() => this.handleChange(1, one)}
            >
              <img src={ImageConst.common.vedioOne} alt="" />
            </div>
            <div
              className={classnames('modcom-matrixpagination-btn', { 'modcom-matrixpagination-btn-active': size === four })}
              onClick={() => this.handleChange(1, four)}
            >
              <img src={ImageConst.common.vedioFour} alt="" />
            </div>
            <div
              className={classnames('modcom-matrixpagination-btn', 'modcom-matrixpagination-btn-last', { 'modcom-matrixpagination-btn-active': size === nine })}
              onClick={() => this.handleChange(1, nine)}
            >
              <img src={ImageConst.common.vedioNine} alt="" />
            </div>
            {!hideLabel && <span>矩阵</span>}
          </div>
        }
      </div>
    );
  }
}

export default MatrixPagination;
