import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import ImageConsts from '@gm/graphmod-assets';
import HlsPlay from './flvvideoNew';
// import Hikvideo from './hikvideo';
import FlvPlay from './flvvideo';

import Pagination from './Pagination';
import './VideoMatrix.scss';
/**
 * 视屏矩阵（1、4、9宫格）
 *
 * @class VideoMatrix
 * @extends {Component}
 */
class VideoMatrixNew extends Component {

  static propTypes = {
    videos: PropTypes.array,
    header: PropTypes.func,
    title: PropTypes.func,
    onSelectClick: PropTypes.func,
    selectVedios: PropTypes.array,
    content: PropTypes.any,
    matrix: PropTypes.number,
    onRefresh: PropTypes.func,
    more: PropTypes.func
  };

  static defaultProps = {
    videos: []
  };

  constructor(props) {
    super(props);
    this.state = {

    };
  }
  // bindRef = ref => { this.child = ref }
  // btnClick = (e) => {
  //   this.child.reloadHlsPlayer(e.id,'http://videocdn.renrenjiang.cn/Act-ss-m3u8-sd/979859_1546052815274/979859_1546052815274.m3u8');
  // }

  render() {
    const { videos, title, onSelectClick, matrix, header, selectVedios, more, dataConfig: { videoMore = true }, onRefresh } = this.props;
    return (
      <div className={classnames('mod-com-videomatrix', `mod-com-videomatrix-${matrix}`)}>
        {videos.map(e => (
          <div
            key={`video${e.id}-${e.url}`}
            onClick={() => onSelectClick && onSelectClick(e)}
            className={classnames('mod-com-videomatrix-item', {
              'mod-com-videomatrix-item-active': (selectVedios || []).some(id => id === e.id)
            })}
          >
            <div className="mod-com-videomatrix-header">
              {!header && title ? (
                <div className="mod-com-videomatrix-title">
                  <img src={ImageConsts.common.vedioLogo} alt="" />
                  {title(e)}
                </div>
              ) : null}
              {header && header(e)}
              {!header && videoMore ? (
                <div className="mod-com-videomatrix-more" onClick={event => more(e, event)}>
                  <img src={ImageConsts.common.listView} alt="" />
                </div>
              ) : null}
            </div>
            <div className="mod-com-videomatrix-content">
              {
                e.id &&
                ( e.vedioFormat && e.vedioFormat === 'flv' ? <FlvPlay vedioId={`video${e.id}`}  token={e.token} liveVideoHost={e.url || ''} code={e.code} />
                  : <HlsPlay vedioId={`video${e.id}`}  token={e.token} liveVideoHost={e.url || ''} code={e.code} />)
              }
            </div>
          </div>
        ))}
      </div>
    );
  }
}

VideoMatrixNew.Pagination = Pagination;

export default VideoMatrixNew;
