import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import 'xgplayer';
import HlsJsPlayer from 'xgplayer-hls.js';

class HlsPlay extends Component {
  static propTypes = {
    vedioId: PropTypes.string,
    token: PropTypes.string,
    width: PropTypes.any,
    height: PropTypes.any,
    videoFlag: PropTypes.string,
    autoFlag: PropTypes.string,
    liveVideoHost: PropTypes.string,
    noMax: PropTypes.any
  };

  constructor(props) {
    super(props);
    this.fullscreen = false;
  }

  componentDidMount() {
    this.playVedio();
  }

  componentWillUnmount() {
    this.hlsPlayer.destroy()
  }


  playVedio = () => {
    const { token, vedioId, liveVideoHost, code } = this.props;
    this.reloadHlsPlayer(vedioId, liveVideoHost);
  }

  /**
  * 加载FLV格式视频
  * @param {*} flvUrl
  */
  reloadHlsPlayer = (id, hlsUrl) => {
    const { width, height } = this.props;
    if (this.hlsPlayer) {
      // 2.有播放器则切换视频源
      this.hlsPlayer.src = hlsUrl;
      this.hlsPlayer.reload();
    } else{
      this.hlsPlayer = new HlsJsPlayer({
        id,
        url: hlsUrl,
        autoplay: this.props.autoFlag === true ? true : false,
        playsinline: true,
        width: width || '100%',
        height: height || '100%', //calc(100% - 32px)
        isLive: true,// 是否直播
        cors: true
      });
    };
  };
  render() {
    const { vedioId, code } = this.props;
    if (vedioId) {
      return (
        <div className={classnames(`mod-com-hikvideo1`)} id={vedioId} />
      );
    } else {
      return (
        <div className={classnames(`mod-com-hikvideo`)} >
          <video width="100%" height="100%" controls="controls" >
            <track kind="captions" />Your browser does not support the video tag.
          </video>
        </div>
      );
    }
  }
}

HlsPlay.propTypes = {
  onFullScreen: PropTypes.func
};

HlsPlay.defaultProps = {
  onFullScreen() { }
};
export default HlsPlay;
