/**
 * webpack 打包配置文件
 * @author ilex
 */
const umdConfig = require('amos-build/lib/umdConfig');
const AssignUMDRoot = require('amos-build/lib/plugins/AssignUMDRoot');
const resolveCwd = require('amos-build/lib/tools/resolveCwd');
const removeFile = require('amos-build/lib/tools/removeFile');
const afModuleMapping = require('amos-framework/lib/moduleMapping').default;
const adModuleMapping = require('amos-antd/lib/moduleMapping').default;

/**
 * 创建 sdk 编译脚本
 * @param {String} vname 项目版本名称，打包完成后会生成对应的文件夹名称，生成文件夹名称不能手动修改
 * @returns {}
 */
module.exports = function sdk(vname = 'lib', configArgs = {}) {
  // 先删除已有版本
  // 采用版本管理每次发布，如果版本号不变，则无需删除指定版本
  removeFile(vname);

  // ------------------------------------------------------
  // 添加webpack加载别名,用于导包重定向，优化打包以及代码
  // 此处需要自己进行定义
  // 👻可修改
  // ------------------------------------------------------
  const alias = {};

  // ------------------------------------
  // 入口点
  // ------------------------------------
  const entry = {
    graphmod: './src/index.js'
  };

  const config = {
    entry,
    outputPath: resolveCwd(vname), // 如果使用版本管理，此处改为 resolveApp(vname)
    filename: '[name].js',
    library: 'globalmod',
    libraryTarget: 'umd',
    libraryExport: 'default',
    alias,
    // 启动 WebWorker
    enableWorker: true,
    // 配置自定义 babel 插件
    babelPlugin: [
      [
        require.resolve('ray-pack-toolkit/lib/babel/SplitImportPlugin'),
        {
          libraryName: ['amos-framework', 'amos-antd'],
          customMapping: {
            // 特殊处理
            'amos-framework': afModuleMapping,
            'amos-antd': adModuleMapping
          }
        }
      ]
    ],
    sourceMap: false,
    // 确保生成均在 body 上的 split 代码
    htmlPluginConfig: {
      // 'blocking'|'defer', 设置 blocking 让其添加在 body 上
      scriptLoading: 'blocking'
    },
    enableSplit: true,
    ...configArgs
  };

  const defaultConfig = umdConfig(config);

  defaultConfig.output.publicPath = '';

  // 合并相同的 globalmod
  defaultConfig.plugins.push(new AssignUMDRoot());

  return defaultConfig;
};
