import * as endConf from 'amos-processor/lib/config/endconf';
import { utils } from 'amos-tool';
import { commonGet, formatUrl, commonPost, formatObjUrl, commonPut, fileDownload } from './request';

const completePrefix = endConf.completePrefix;
const AmosConfig = endConf.AmosConfig;
const baseURI = AmosConfig.httpURI.baseURI;
const fileServerURI = AmosConfig.httpURI.fileServerURI;

export const UrlConsts = {
  userInfoUrl: url => completePrefix(baseURI, 'privilege/v1/agencyuser/me'), // 根据字典标识获取字典列表 get
  dictListUrl: url => completePrefix(baseURI, 'systemctl/v1/dictionary/{dictCode}/values'), // 根据字典标识获取字典列表 get
  platFormUploadfileUrl: url => completePrefix(baseURI, 'systemctl/v1/filestorage'), // 平台文件服务器上传接口
  lookFileUrl: url => completePrefix('/fileURI/', url), // 查看图片 fileURI需要走转向代理
  getRegionUrl: url => completePrefix(baseURI, 'systemctl/v1/region/tree'), // 获取行政区划
  remoteUrl: completePrefix(baseURI, 'morphic/biz/url'), // 请求第三方系统 api， post，需要传入第三方api 地址
  generateSqlUrl: url => completePrefix(baseURI, 'studio/v1/dataApi/generateSQL') // 通用导出SQL脚本 get
};
/**
 * 根据字典标识获取字典列表
 */
export const dictAction = dictCode => {
  return commonGet(formatUrl(UrlConsts.dictListUrl(), { dictCode }));
};

/**
 * 获取用户信息
 */
export const userInfoAction = () => {
  return commonGet(UrlConsts.userInfoUrl());
};

/**
 * 文件上传
 * @param {*} file  file对象
 */
export const fileUploadAction = file => {
  const formData = new window.FormData();
  formData.append('file', file);
  return commonPost(UrlConsts.platFormUploadfileUrl(), formData);
};

/**
 * 获取行政区划
 */
export const getRegion = () => {
  return commonGet(formatUrl(UrlConsts.getRegionUrl()));
};

/**
 * 图片文件路径补全
 * @param {string} fileUrl
 */
export const filePrefixUrl = fileUrl => completePrefix(fileServerURI, fileUrl);

/**
 * 图片文件路径补全
 * @param {string} url
 */
export const filePrefixUrl2 = url => {
  const prefix = fileServerURI === '/' ? '' : fileServerURI;
  const tempUrl = prefix + url;
  return utils.isUrl(url) ? url : tempUrl;
};

/**
 * 通用请求
 */
export const invokeRemoteApi = (data) => {
  return commonPost(UrlConsts.remoteUrl, data);
};

/**
 * 通用导出SQL脚本
 */
export const templateDownload = (params) => {
  return fileDownload({ url: formatObjUrl({ url: UrlConsts.generateSqlUrl(), filter: params }) });
};

