import { utils } from 'amos-tool';
import * as endConf from 'amos-processor/lib/config/endconf';

const AmosConfig = endConf.AmosConfig;
const bizURI = AmosConfig.httpURI.bizURI;

/**
 * 全局数据类(可设置全局数据、全局方法)
 * @class GlobalConfig
 */
class GlobalConfig {
  constructor() {
    this.requestHeader = {};
    this.URI = {};
    this.initialExecuMethod = {};
  }

  /**
   * 设置全局自定义数据
   * @param {*} name 数据名称
   * @param {*} value 数据值
   * @memberof GlobalConfig
   */
  setCustomData = (name, value) => {
    if (['initialExecuMethod'].includes(name)) {
      console.log(`<initialExecuMethod名称不能使用>`);
      return;
    }
    this[name] = value;
  };
  /**
   * 获取全局自定义数据
   * @param {*} name 数据名称
   * @memberof GlobalConfig
   */
  getCustomData = name => {
    return this[name];
  };
  /**
   * 设置全局初始加载执行函数
   * @param {*} name 方法标识名称（全局唯一）
   * @param {*} isCover 是否覆盖重名方法
   * @param {*} canRepeatExecu 是否可以重复执行此方法
   * @param {*} method 方法
   * @memberof GlobalConfig
   */
  setInitialExecuMethod = (name, isCover, canRepeatExecu, method) => {
    if (utils.isFunction(method) && name) {
      if (this.initialExecuMethod[name]) {
        if (!isCover) {
          console.log(`<${name}方法已经存在>`);
        }
      }
      this.initialExecuMethod[name] = { method, canRepeatExecu };
    }
  };
  /**
   * 根据名称执行全局初始函数
   * @param {*} name
   * @memberof GlobalConfig
   */
  execuInitialMethod = name => {
    if (name && this.initialExecuMethod[name] && this.initialExecuMethod[name].method) {
      this.initialExecuMethod[name].method();
      if (!this.initialExecuMethod[name].canRepeatExecu) {
        this.initialExecuMethod[name].method = null;
      }
    }
  };
  /**
   * 执行所有全局初始函数
   * @memberof GlobalConfig
   */
  execuAllInitialMethod = () => {
    Object.keys(this.initialExecuMethod || {}).map(e => {
      this.execuInitialMethod(e);
      return e;
    });
  };
  /**
   * 设置后端服务接口调用的请求头信息
   * @param {*} data
   */
  setRequestHeader(data) {
    this.requestHeader = data || {};
  }
  /**
   * 获取后端服务接口调用的请求头信息
   * @return {*}
   * @memberof GlobalConfig
   */
  getRequestHeader() {
    return this.requestHeader;
  }
  /**
   * 设置后端服务地址
   * @param {*} data
   */
  setURI(data) {
    if (utils.isObject(data)) {
      this.URI = data || {};
    } else {
      this.URI = {};
    }
  }
  /**
   * 获取后端服务地址
   * @param {*} data
   */
  getURI(key = 'bizURI') {
    // console.log('============>', this.URI, this.URI[key]);
    if (!this.URI[key]) {
      return bizURI || '/';
    }
    return this.URI[key];
  }
}

export default new GlobalConfig();
