const { getReactMf } = require('amos-build/lib/tools/pluginConfig');
const { devDependencies: deps } = require("./package.json");

module.exports = {
  // dir 和 list 用于从 pkg 中拷贝 mf 包
  dir: 'mf_lib',
  list: [
    { pkg: 'amos-mf', mf: 'amosmf_dist' }
  ],
  // 用于替换引入路径，修改为 mf 暴露的路径
  replacer: {
    rules: [
      // 通用 mf
      { src: 'amos-amap', dest: 'amosmf/amos-amap' },
      { src: 'amos-gojs', dest: 'amosmf/amos-gojs' },
      { src: 'amos-3d', dest: 'amosmf/amos-3d' },
      { src: 'amos-3d/lib/designer', dest: 'amosmf/amos-3d-designer' }
    ]
  },
  remotes: {
    amosmf: "amosmf@[window.__mf_prefix_url__]/amosmf_dist/remoteEntry.js",
    // webstudio， 该 mf 必须保存在 foundation view 同级
    amosasp: 'amosasp@[window.__mf_prefix_url__]/amosasp_dist/remoteEntry.js'
  },
  shared: {
    ...getReactMf(deps.react, deps['react-dom'])
  }
};
