/**
 *
 * @authors ilex
 * @date    2016-07-18 16:42:35
 * @description 主入口模块
 */
import { browserHistory } from 'amos-react-router';
import { OAuth } from '@gm/graphmod-utils';
import { PageCase } from 'amos-designer';
import SimulationPage from './SimulationPage';
import { getComponentKeyList } from './sketch';
import config from './../config.json';

import './index.scss';

window.gmconfig = config;

const { generateRoutes, renderApp, invokeLoginAction } = PageCase;
const componentKeys = getComponentKeyList();

function onItemClick(key) {
  browserHistory.push(key);
}

/**
 * 获取 path key
 * @param {*} ck sketchComponent/clib-file
 * @returns  {String} clib-file
 */
function getPathKey(ck) {
  if (ck.indexOf('/') > 0) {
    return ck.split('/')[1];
  }
  return ck;
}

invokeLoginAction(OAuth.loginAction, OAuth.accessAction);

const rootRoutes = generateRoutes({
  componentKeys,
  onItemClick,
  mockData: {},
  SimulationPage,
  getPathKey
});

renderApp({
  history: browserHistory,
  rootRoutes
});

// 开发模式下开启 热加载 (不需要开启时，屏蔽一下代码即可)
if (module.hot) {
  module.hot.accept();
}
