import { IModularHub, INNER_MODULAR_TYPE } from 'amos-viz/lib/widgets';
import Unknown from '@gm/graphmod-common/src/Unknown';
import mods from './../src';

console.log(mods);

/**
 * hybrid 创建自己独立的 modular
 * 注册 所有的 mod
 */
export const hybridModular = new IModularHub();

// 注册未知组件
hybridModular.registerSketchComponent('unknown', Unknown);

Object.keys(mods).forEach(k => {
  // 需要排除 default
  if (k !== 'default'){
    hybridModular.registerSketchComponent(k, mods[k]);
  }
});

export function getComponentKeyList(){
  const sc = hybridModular.getModularsByType(INNER_MODULAR_TYPE.sketchComponent);
  // const sc = hybridModular.getObjModularsByType(INNER_MODULAR_TYPE.sketchComponent);
  return [...sc.keys()].map(item => item.replace(`${INNER_MODULAR_TYPE.sketchComponen}/`, ''));
}

export default function getSketchCompnents(alias){
  return hybridModular.getModularClass(INNER_MODULAR_TYPE.sketchComponent, alias, Unknown);
}
