import React from 'react';
import PropTypes from 'prop-types';
import { Form, Input } from 'amos-framework';
import { withModalForm, BaseForm } from 'amos-designer';
import { api, tools } from '@gm/graphmod-utils';

const { templateDownload } = api;
const FormItem = Form.Item;

/**
 * 导入数据
 * @class ImportData
 * @extends {Component}
 */
@withModalForm({
  width: 400,
  title: '导出SQL脚本'
})
class DownloadModel extends BaseForm {
  constructor(props) {
    super(props);
    const user = tools.getUserOrg() ?? {};
    this.state = {
      form: {
        agencyCode: user.agencyCode ?? ''
      }
    };
  }

  onCancel = () => {
    this.setState({ form: {} }, () => {
      this.props.onClose && this.props.onClose();
    });
  };

  onSubmit = () => {
    const { selectedRowKeys = [], dataConfig = {} } = this.props;
    this.props.onClose();
    this.props.handleOpen('logsVisible');
    if (dataConfig.dimension && selectedRowKeys.length > 0) {
      dataConfig[dataConfig.dimension] = selectedRowKeys.join(',');
    }
    templateDownload(dataConfig);
  };

  render() {
    const { form } = this.state;

    return (
      <Form
        style={{ paddingRight: 20 }}
        ref={this.props.saveFormRef}
        model={form}
        labelWidth="8em"
        filled
      >
        <FormItem label="所属机构" field="agencyCode">
          <Input placeholder="请输入" value={form.agencyCode} onChange={this.genHandle('agencyCode')} />
        </FormItem>
      </Form>
    );
  }
}

DownloadModel.propTypes = {
  saveFormRef: PropTypes.func,
  visible: PropTypes.bool,
  onClose: PropTypes.func
};

export default DownloadModel;
