import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Tabs, TagSelect, StdFormRow, CardPane, BorderRadius} from 'amos-framework';
import { Row, Col } from 'amos-framework';
import { getSortSences } from './api';


const { TabList, Tab, TabPanel } = Tabs;
const categoryScene = ['全部', '新能源', '水利环境', '医疗健康', '智慧城市', '智慧园区', '企业运营', '物流仓库', '生产制造', '其他']
const miniSences = ['综合排序', '热门推荐', '最新发布']


function ListCards({cardItems}) {
  const rows = [];
  // console.log("传入ListCards中的carditems:")
  // console.log(cardItems)

  for (let i = 0; i < cardItems.length; i += 4) {
    const rowItems = cardItems.slice(i, i + 4);

    const cols = rowItems.map((cardItems, index) => (
      <Col span={6} key={index}>
        <div style={{margin: 30,display:'flex',justifyContent:'center'}}>
          <CardPane style={{ width:300 ,height:240,border:0}} bodyStyle={{ padding: 0}}>
            <div style={{height:'75%'}}>
              <img alt="example" width="100%" height='160px' style={{objectFit:'cover',borderRadius:10}} src={+cardItems.sketch} />
            </div>
            <div style={{ padding: '10px 0px 10px 50px' }}>
              <h2 style={{ margin: 0 }}>{cardItems.templateName}</h2>
              <div style={{display : 'flex'}}>  
                <p style={{ textAlign: 'left', marginTop: '5px' }}>热度指数:{cardItems.viewTimes}</p>
              <p style={{ textAlign: 'left', marginTop: '5px' }}>{cardItems.agencyName}</p>
              </div>
            </div>
          </CardPane>
        </div>
      </Col>
    ));

    rows.push(
      <Row gutter={16} key={(i + 1) / 4 | 0}>
        {cols}
      </Row>
    );
  }
  return <div>{rows}</div>
}

class Shifting extends Component {


  static propTypes = {
    routeState: PropTypes.object,
    onBack: PropTypes.func
  };

  static contextTypes = {
    browserHistory: PropTypes.object
  };

  static defaultProps = {
    routeState: {}
  };

  componentDidMount() {
    this.getSenceLists();
  }

  constructor(props) {
    super(props);
    this.state = {
      mode: 'divider',
      cardItems: [],
      selectSence: categoryScene[0],
      selectMiniSence: miniSences[0]
      // mode2: 'line',
      // mode3: 'bullet'
    };
  }

  handleBack = () => {
    if (this.props.onBack) {
      this.props.onBack();
    } else {
      this.context.browserHistory.goBack();
    }
  };
  handleChange = (value) => {
    this.setState({
      mode: value
    });
  }
  getSenceLists = () => {
    getSortSences(this.state.selectSence, this.state.selectMiniSence).then(response => {
      this.setState({
        cardItems: response
      });
      // console.log(this.state.cardItems);
    })
  }
  handleSenecesSubmit = (value) => {
    if (value !== '') {
      this.setState({
        selectSence : value
      })
      this.getSenceLists();
    }
  }
  handleMiniSenecesSubmit = (value) => {
    if (value !== '') {
      this.setState({
        selectMiniSence : value
      })
      this.getSenceLists();
    }
  }



render() {

  const {mode} = this.state;
  const Option = TagSelect.Option;
  // this.getSenceLists();
  return (
    <div>
      <Tabs mode={mode}>
        <TabList>
          <span>&nbsp;&nbsp;</span>
          <Tab>&nbsp;&nbsp;应用模板&nbsp;&nbsp;</Tab>
          <Tab>&nbsp;&nbsp;三维模型&nbsp;&nbsp;</Tab>
        </TabList>
        <TabPanel>
          <StdFormRow  label="场景" block id = 'scene' style={{padding:'11px 0px 11px 20px',}}>
            <TagSelect defaultValue = {categoryScene[0]} data={categoryScene} onChange={this.handleSenecesSubmit} expandable single />
          </StdFormRow>
          <StdFormRow  block style={{ padding:'0px 0px 11px 20px'}}>
            <TagSelect defaultValue = {miniSences[0]} data={miniSences} onChange={this.handleMiniSenecesSubmit} expandable single />
          </StdFormRow>
          <ListCards cardItems={this.state.cardItems}/>
        </TabPanel>

        <TabPanel>一级选项卡 - 面板2</TabPanel>
      </Tabs>
    </div>
  );
}
}

export default Shifting;

