import { EsEnum } from '@gm/graphmod-utils';

/**
 * 辅屏菜单枚举
 */
export const MenuEnum = new EsEnum([
  { code: 'ALL', value: 'all', label: '全国换流站展示菜单标识' },
  { code: 'STATION', value: 'station', label: '单个换流站菜单标识' }
]);

/**
 * 告警颜色枚举
 */
export const AlarmColorEnum = new EsEnum([
  { code: 'FIREALARM', color: '#D32029' },
  { code: 'faultAlarm', color: '#D87A16' },
  { code: 'RunStatus', color: '#49AA19' },
  { code: 'Alarm', color: '#D32029' },
  { code: 'Heartbeat', color: '#49AA19' },
  { code: 'Action', color: '#E8D639' },
  { code: 'Reset', color: '#49AA19' },
  { code: 'ShieldAlarm', color: '#E8D639' },
  { code: 'Abnormal', color: '#D87A16' },
  { code: 'Feedback', color: '#D87A16' },
  { code: 'PowerLoss', color: '#D87A16' },
  { code: 'StartStop', color: '#D87A16' },
  { code: 'Activation', color: '#D87A16' },
  { code: 'Status', color: '#49AA19' },
  { code: 'Normal', color: '#49AA19' },
  { code: 'Indicate', color: '#E8D639' },
  { code: 'Tripping', color: '#D32029' },
  { code: 'OilLeak', color: '#D32029' }
]);

/**
 * 治理进度枚举
 */
export const DangerStateEnum = new EsEnum([
  { code: 'PADDING_REVIEW', value: '1', label: '待评审', img: 'upload/sfcc/common/image/动态信息.png' },
  { code: 'PADDING_GOVERNANCE', value: '2', label: '待治理', img: 'upload/sfcc/common/image/动态信息.png' },
  { code: 'PADDING_VERIFIED', value: '3', label: '安措计划中', img: 'upload/sfcc/common/image/动态信息.png' },
  { code: 'PADDING_VERIFIED', value: '4', label: '待验证', img: 'upload/sfcc/common/image/动态信息.png' },
  { code: 'GOVERNANCE_OVER', value: '5', label: '治理完毕', img: 'upload/sfcc/common/image/动态信息.png' },
  { code: 'RESCINDED', value: '6', label: '已撤销', img: 'upload/sfcc/common/image/动态信息.png' },
  { code: 'DELAY_UNDER_GOVERNANCE', value: '7', label: '延期治理中', img: 'upload/sfcc/common/image/动态信息.png' },
  { code: 'DELAY_PADDING_DEPARTMENT_AUDIT', value: '8', label: '延期待车间/部门审核', img: 'upload/sfcc/common/image/动态信息.png' },
  { code: 'DELAY_PADDING_COMPANY_AUDIT', value: '9', label: '延期待公司审核', img: 'upload/sfcc/common/image/动态信息.png' }
]);
