import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Tabs } from 'amos-framework';
import InstructionFlow from './InstructionFlow';
import { ScreenCard } from './../../common';

const { TabList, Tab, TabPanel } = Tabs;

/**
 * 灾情信息-中间tab页（指令流、ACDM、战评总结）
 *
 * @class DisasterTabs
 * @extends {Component}
 */
class DisasterTabs extends Component {

  static propTypes = {
    alarm: PropTypes.object
  };

  static defaultProps = {
    alarm: {}
  };

  constructor(props) {
    super(props);
    this.state = {
      activeKey: 'instructionFlow'
    };
  }

  handleChange = (index, key) => {
    this.setState({
      activeKey: key
    });
  }

  render() {
    // const { activeKey } = this.state;
    return (
      <ScreenCard title="指令流" className="ccs-disaster-dynamicinfo-details">
        <InstructionFlow {...this.props} />
        {
          // <Tabs className="ccs-tabs" activeKey={activeKey} onChange={this.handleChange}>
          //   <TabList>
          //     <Tab activeKey="instructionFlow">指令流</Tab>
          //   </TabList>
          //   <TabPanel activeKey="instructionFlow">
          //     <InstructionFlow {...this.props} />
          //   </TabPanel>
          // </Tabs>
        }
      </ScreenCard>
    );
  }
}

export default DisasterTabs;
