import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Paragraph } from 'amos-framework';
import { withSubscribeMQTT } from './../../common';

import AlarmDetails from './AlarmDetails';

import { instructionFlowListAction } from './../../api';

/**
 * 灾情信息-指令流
 *
 * @class InstructionFlow
 * @extends {Component}
 */
class InstructionFlow extends Component {
  static propTypes = {
    alarm: PropTypes.object,
    messageFlag: PropTypes.bool
  };

  static defaultProps = {
    alarm: {}
  };

  constructor(props) {
    super(props);
    this.state = {
      data: []
    };
  }

  componentDidMount() {
    this.requestData();
  }

  componentDidUpdate(prevProps, prevState) {
    if (this.props.messageFlag !== prevProps.messageFlag) {
      this.requestData();
    }
  }

  requestData = () => {
    const { alarm } = this.props;
    // instructionFlowListAction(alarm.id).then(d => {
    //   this.setState({ data: d || [] });
    // });
    let data = [
      {
        content: '疏散引导组已疏散主控楼被困人员',
        sequenceNbr: '4',
        submissionTime: '2021-12-03 11:55:33'
      },
      {
        content: '消防应急小组已到达换流站应急指挥中心',
        sequenceNbr: '3',
        submissionTime: '2021-12-03 11:50:33'
      },
      {
        content: '极Ⅰ高端YY换流变B项火灾确认',
        sequenceNbr: '2',
        submissionTime: '2021-12-03 11:45:33'
      },
      {
        content: '主控楼2层202极1冷却设备室N001L01D001烟感火灾报警',
        sequenceNbr: '1',
        submissionTime: '2021-12-03 11:39:33'
      }
    ];
    this.setState({
      data
    });
  };

  render() {
    const { data } = this.state;
    return (
      <div className="ccs-instructionflow ccs-scrollbar">
        { data.map((item, index) => (
          <div key={item.sequenceNbr} className="ccs-instructionflow-item">
            <div className="ccs-instructionflow-index">
              <img src={`upload/sfcc/common/image/${index === 0 ? 'index-active' : 'index'}.png`} alt="" />
              <span>{data.length - index}</span>
            </div>
            <div className="ccs-instructionflow-content">
              <div className="ccs-instructionflow-header">
                <span className="ccs-instructionflow-time">{item.submissionTime}</span>
                {
                  // <span className="ccs-instructionflow-type">{item.type}</span>
                  // <span className="ccs-instructionflow-unit"><img src="/upload/jcs/common/icon/单位.png" alt="" />{item.company}</span>
                }
              </div>
              <div className="ccs-instructionflow-info">
                <Paragraph html={item.content} />
              </div>
            </div>
          </div>
        ) )
        }
      </div>
    );
  }
}

export default InstructionFlow;
