import React from 'react';
import PropTypes from 'prop-types';
import { Form, Input, Select } from 'amos-framework';
import { BaseForm, withModalForm } from 'amos-designer';
import {
  frontLineLiaisonAddAction,
  frontLineLiaisonUpdateAction,
  dictionaryAction
} from './../../../api';

const FormItem = Form.Item;
const Option = Select.Option;
/**
 * 前线联络添加编辑页面
 *
 * @class ListMgmt
 * @extends {BaseForm}
 */
@withModalForm({ width: 460, name: '前线联络' })
class ListMgmt extends BaseForm {
  constructor(props) {
    super(props);
    this.state = {
      form: {},
      gwList: [],
      rules: {
        jobTitleCode: this.formRules.select,
        name: this.formRules.normalText(),
        phone: this.formRules.mobile({ required: true })
      }
    };
  }

  componentDidMount() {
    this.onInit();
  }

  onInit = () => {
    const { data } = this.props;
    // dictionaryAction('GWMC').then(d => {
    //   this.setState({ gwList: d || [] });
    // });
    const gwList = [
      {
        id: '1',
        name: '安全员'
      },
      {
        id: '2',
        name: '疏散员'
      }
    ];
    this.pageType = data ? 'edit' : 'add';
    this.setState({ gwList, form: data || {} });
  };

  onCancel = () => {
    this.setState({ form: {} }, () => {
      this.props.onClose && this.props.onClose();
    });
  };

  onSubmit = () => {
    const { alarm } = this.props;
    const { gwList, form } = this.state;
    const { sub } = this.props;
    form.jobTitle = (gwList.find(d => d.id === form.jobTitleCode) || {}).name;
    sub(form);
    // this.props.formSubmit({
    //   action: this.pageType === 'add' ? frontLineLiaisonAddAction : frontLineLiaisonUpdateAction,
    //   onSuccess(){},
    //   onError(){},
    //   changeValues: values => {
    //     values.alertCalledId = alarm.id;
    //     values.jobTitle = (gwList.find(d => d.id === values.jobTitleCode) || {}).name;
    //     return values;
    //   }
    // });
  };

  onChange = (key, value) => {
    const { form } = this.state;
    form[key] = value;
    this.setState({ form });
  }

  render() {
    const { rules, form, gwList } = this.state;
    return (
      <Form
        style={{ padding: '20px 20px 10px 20px' }}
        rules={rules}
        ref={this.props.saveFormRef}
        model={form}
        labelWidth="4em"
        filled
        className="ccs-form"
      >
        <FormItem label="岗位" field="jobTitleCode">
          <Select popoverClassName="ccs-select-popover" value={form.jobTitleCode} onChange={(e) => this.onChange('jobTitleCode', e)}>
            <Option>请选择</Option>
            {
              gwList.map(e => (
                <Option key={e.id} value={e.id}>{e.name}</Option>
              ))
            }
          </Select>
        </FormItem>
        <FormItem label="姓名" field="name">
          <Input value={form.name} onChange={(e) => this.onChange('name', e.target.value)}/>
        </FormItem>
        <FormItem label="电话" field="phone">
          <Input value={form.phone} onChange={(e) => this.onChange('phone', e.target.value)}/>
        </FormItem>
      </Form>
    );
  }
}

ListMgmt.propTypes = {
  alarm: PropTypes.object,
  data: PropTypes.object,
  sub: PropTypes.func
};

export default ListMgmt;
