import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Button, Icon } from 'amos-framework';
import { UUID } from 'amos-tool';
import { TableList, ScreenCard } from './../../../common';
import ListMgmt from './ListMgmt';
import {
  frontLineLiaisonListAction,
  frontLineLiaisonDeleteAction
} from './../../../api';
/**
 * 前线联络
 * @class FrontLineLiaison
 * @extends {Component}
 */
class FrontLineLiaison extends Component {

  static propTypes = {
    alarm: PropTypes.object
  };

  static defaultProps = {
    alarm: {}
  };

  constructor(props) {
    super(props);
    this.state = {
      visible: false,
      updateObj: undefined,
      dataSource: []
    };
  }

  componentDidMount() {
    this.requestData();
  }

  requestData = () => {
    const { alarm } = this.props;
    // frontLineLiaisonListAction(alarm.id).then(d => {
    //   this.setState({ dataSource: d || [] });
    // });
    const dataSource = [
      {
        sequenceNbr: '1',
        name: '赵云',
        jobTitle: '安全员',
        phone: '13422222222',
        jobTitleCode: '1'
      }
    ];
    this.setState({
      dataSource
    });
  }

  onDelete = (record) => {
    frontLineLiaisonDeleteAction(record.sequenceNbr).then(d => {
      this.requestData();
    });
  }

  handleAddOpen = () => {
    this.setState({ visible: true, updateObj: undefined });
  }

  handleEditOpen = (record) => {
    this.setState({ visible: true, updateObj: record });
  }

  onClose = () => {
    this.setState({ visible: false, updateObj: undefined });
  }

  renderColumns = () => {
    return [
      { dataIndex: 'name', title: '姓名', width: '25%' },
      { dataIndex: 'jobTitle', title: '岗位', width: '30%' },
      { dataIndex: 'phone', title: '电话', width: '30%' },
      { dataIndex: 'sequenceNbr', title: '操作', width: '15%',
        render: (text, record) =>
          <span>
            <a title="编辑" onClick={()=>this.handleEditOpen(record)}><Icon icon="pencil" /></a>
            <a title="删除" onClick={()=>this.onDelete(record)}><Icon icon="delete1" /></a>
          </span>
      }
    ];
  }

  sub = (obj) => {
    let { dataSource } = this.state;
    obj.sequenceNbr = UUID.uuid('16');
    dataSource.push(obj);
    this.setState({
      dataSource,
      visible: false
    });
  }

  render() {
    const { alarm } = this.props;
    const { dataSource, updateObj, visible } = this.state;
    return (
      <ScreenCard
        title="前线联络"
        other={<Button className="ccs-com-screencard-btn" onClick={this.handleAddOpen}>新增</Button>}
        wrapperClassName="ccs-disaster-frontlineliaison"
      >
        <TableList
          columns={this.renderColumns()}
          rowKey="sequenceNbr"
          dataSource={dataSource}
        />
        {
          visible &&
          <ListMgmt
            reload={this.requestData}
            modalProps={{ className: 'ccs-modal' }}
            visible={visible}
            onClose={this.onClose}
            data={updateObj}
            alarm={alarm}
            sub={this.sub}
          />
        }
      </ScreenCard>
    );
  }
}

export default FrontLineLiaison;
