import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Hikvideo ,HlsPlay } from '@gm/graphmod-common';
/**
 * VideoItem
 *
 * @class VideoItem
 * @extends {Component}
 */
class VideoItem extends Component {

  static propTypes = {
    videoConfig: PropTypes.object,
    title: PropTypes.object
  };

  static defaultProps = {
    videoConfig: {}
  };

  constructor(props) {
    super(props);
    this.state = {

    };
  }


  render() {
    const { title,  ...videoConfig } = this.props;
    // debugger
    return (
      <div className="ccs-disaster-videos-item">
        <div className="ccs-disaster-videos-title">{title}
        </div>
        <HlsPlay {...videoConfig} />
      </div>
    );
  }
}

export default VideoItem;
